/*
 * Decompiled with CFR 0.152.
 */
package com.platon.codegen;

import com.platon.TempFileProvider;
import com.platon.codegen.WasmFunctionWrapperGenerator;
import com.platon.utils.Strings;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.junit.Assert;
import org.junit.Test;

public class WasmFunctionWrapperGeneratorTest
extends TempFileProvider {
    private String solidityBaseDir;

    public void setUp() throws Exception {
        super.setUp();
        URL url = WasmFunctionWrapperGeneratorTest.class.getClassLoader().getResource("wasm");
        this.solidityBaseDir = url.getPath();
    }

    @Test
    public void testTweetAccount() throws Exception {
        this.testCodeGenerationJvmTypes("tweetAccount", "TweetAccount");
    }

    @Test
    public void testContractEmitEventWithAddr() throws Exception {
        this.testCodeGenerationJvmTypes("contractEmitEventWithAddr", "ContractEmitEventWithAddr");
    }

    @Test
    public void testEventTopic() throws Exception {
        this.testCodeGenerationJvmTypes("eventTopic", "EventTopic");
    }

    private void testCodeGenerationJvmTypes(String contractName, String inputFileName) throws Exception {
        this.testCodeGeneration(contractName, inputFileName, "org.web3j.contract.java", "--javaTypes");
    }

    private void testCodeGeneration(String contractName, String inputFileName, String packageName, String types) throws Exception {
        WasmFunctionWrapperGenerator.main((String[])Arrays.asList(types, this.solidityBaseDir + File.separator + contractName + File.separator + "build" + File.separator + inputFileName + ".wasm", this.solidityBaseDir + File.separator + contractName + File.separator + "build" + File.separator + inputFileName + ".abi.json", "-p", packageName, "-o", this.tempDirPath).toArray(new String[0]));
        this.verifyGeneratedCode(this.tempDirPath + File.separator + packageName.replace('.', File.separatorChar) + File.separator + Strings.capitaliseFirstLetter((String)inputFileName) + ".java");
    }

    private void verifyGeneratedCode(String sourceFile) throws IOException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        try (StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);){
            Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromStrings(Arrays.asList(sourceFile));
            JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, null, null, compilationUnits);
            boolean result = task.call();
            System.out.println(diagnostics.getDiagnostics());
            Assert.assertTrue((String)"Generated contract contains compile time error", (boolean)result);
        }
    }
}

