/*
 * Decompiled with CFR 0.152.
 */
package com.platon.codegen;

import com.platon.codegen.SolidityFunctionWrapperGeneratorTest;
import com.platon.codegen.TruffleJsonFunctionWrapperGenerator;
import com.platon.protocol.core.methods.response.AbiDefinition;
import java.io.File;
import java.net.URL;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ContractJsonParseTest {
    static final String BUILD_CONTRACTS = "build" + File.separator + "contracts";
    private String contractBaseDir;

    static String jsonFileLocation(String baseDir, String contractName, String inputFileName) {
        return baseDir + File.separator + contractName + File.separator + BUILD_CONTRACTS + File.separator + inputFileName + ".json";
    }

    static TruffleJsonFunctionWrapperGenerator.Contract parseContractJson(String baseDir, String contractName, String inputFileName) throws Exception {
        String fileLocation = ContractJsonParseTest.jsonFileLocation(baseDir, contractName, inputFileName);
        return TruffleJsonFunctionWrapperGenerator.loadContractDefinition((File)new File(fileLocation));
    }

    @Before
    public void setUp() throws Exception {
        URL url = SolidityFunctionWrapperGeneratorTest.class.getClassLoader().getResource("truffle");
        this.contractBaseDir = url.getPath();
    }

    @Test
    public void testParseMetaCoin() throws Exception {
        TruffleJsonFunctionWrapperGenerator.Contract mc = ContractJsonParseTest.parseContractJson(this.contractBaseDir, "MetaCoin", "MetaCoin");
        Assert.assertEquals((String)"Unexpected contract name", (Object)"MetaCoin", (Object)mc.getContractName());
    }

    @Test
    public void testParseConvertLib() throws Exception {
        TruffleJsonFunctionWrapperGenerator.Contract mc = ContractJsonParseTest.parseContractJson(this.contractBaseDir, "MetaCoin", "ConvertLib");
        Assert.assertEquals((String)"Unexpected contract name", (Object)"ConvertLib", (Object)mc.getContractName());
        Assert.assertEquals((String)"Unexpected number of functions", (long)1L, (long)mc.abi.size());
        AbiDefinition abi = (AbiDefinition)mc.abi.get(0);
        Assert.assertEquals((String)"Unexpected function name", (Object)"convert", (Object)abi.getName());
        Assert.assertTrue((String)"Expected function to be 'constant'", (boolean)abi.isConstant());
        Assert.assertFalse((String)"Expected function to not be 'payable'", (boolean)abi.isPayable());
        Assert.assertEquals((String)"Expected abi to represent a function", (Object)"function", (Object)abi.getType());
        Assert.assertEquals((String)"Expected the 'pure' for the state mutability setting", (Object)"pure", (Object)abi.getStateMutability());
    }
}

