/*
 * Decompiled with CFR 0.152.
 */
package com.platon.contracts.ppos;

import com.platon.abi.solidity.datatypes.BytesType;
import com.platon.abi.solidity.datatypes.generated.Uint16;
import com.platon.abi.solidity.datatypes.generated.Uint256;
import com.platon.abi.solidity.datatypes.generated.Uint64;
import com.platon.bech32.Bech32;
import com.platon.contracts.ppos.BaseContract;
import com.platon.contracts.ppos.abi.Function;
import com.platon.contracts.ppos.dto.CallResponse;
import com.platon.contracts.ppos.dto.TransactionResponse;
import com.platon.contracts.ppos.dto.enums.StakingAmountType;
import com.platon.contracts.ppos.dto.resp.Delegation;
import com.platon.contracts.ppos.dto.resp.DelegationIdInfo;
import com.platon.contracts.ppos.exception.EstimateGasException;
import com.platon.contracts.ppos.exception.NoSupportFunctionType;
import com.platon.crypto.Credentials;
import com.platon.parameters.NetworkParameters;
import com.platon.protocol.Web3j;
import com.platon.protocol.core.RemoteCall;
import com.platon.protocol.core.methods.response.Log;
import com.platon.protocol.core.methods.response.PlatonSendTransaction;
import com.platon.protocol.core.methods.response.TransactionReceipt;
import com.platon.protocol.exceptions.TransactionException;
import com.platon.rlp.solidity.RlpDecoder;
import com.platon.rlp.solidity.RlpList;
import com.platon.rlp.solidity.RlpString;
import com.platon.tx.TransactionManager;
import com.platon.tx.gas.GasProvider;
import com.platon.utils.Numeric;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

public class DelegateContract
extends BaseContract {
    public static DelegateContract load(Web3j web3j) {
        return new DelegateContract(NetworkParameters.getPposContractAddressOfStaking(), web3j);
    }

    public static DelegateContract load(Web3j web3j, TransactionManager transactionManager) {
        return new DelegateContract(NetworkParameters.getPposContractAddressOfStaking(), web3j, transactionManager);
    }

    public static DelegateContract load(Web3j web3j, Credentials credentials) {
        return new DelegateContract(NetworkParameters.getPposContractAddressOfStaking(), web3j, credentials);
    }

    private DelegateContract(String contractAddress, Web3j web3j) {
        super(contractAddress, web3j);
    }

    private DelegateContract(String contractAddress, Web3j web3j, Credentials credentials) {
        super(contractAddress, web3j, credentials);
    }

    private DelegateContract(String contractAddress, Web3j web3j, TransactionManager transactionManager) {
        super(contractAddress, web3j, transactionManager);
    }

    public RemoteCall<TransactionResponse> delegate(String nodeId, StakingAmountType stakingAmountType, BigInteger amount) {
        Function function = this.createDelegateFunction(nodeId, stakingAmountType, amount);
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionResponse> delegate(String nodeId, StakingAmountType stakingAmountType, BigInteger amount, GasProvider gasProvider) {
        Function function = this.createDelegateFunction(nodeId, stakingAmountType, amount);
        return this.executeRemoteCallTransaction(function, gasProvider);
    }

    public GasProvider getDelegateGasProvider(String nodeId, StakingAmountType stakingAmountType, BigInteger amount) throws IOException, EstimateGasException, NoSupportFunctionType {
        Function function = this.createDelegateFunction(nodeId, stakingAmountType, amount);
        return this.getDefaultGasProvider(function);
    }

    public RemoteCall<PlatonSendTransaction> delegateReturnTransaction(String nodeId, StakingAmountType stakingAmountType, BigInteger amount) {
        Function function = this.createDelegateFunction(nodeId, stakingAmountType, amount);
        return this.executeRemoteCallTransactionStep1(function);
    }

    public RemoteCall<PlatonSendTransaction> delegateReturnTransaction(String nodeId, StakingAmountType stakingAmountType, BigInteger amount, GasProvider gasProvider) {
        Function function = this.createDelegateFunction(nodeId, stakingAmountType, amount);
        return this.executeRemoteCallTransactionStep1(function, gasProvider);
    }

    private Function createDelegateFunction(String nodeId, StakingAmountType stakingAmountType, BigInteger amount) {
        Function function = new Function(1004, Arrays.asList(new Uint16((long)stakingAmountType.getValue()), new BytesType(Numeric.hexStringToByteArray((String)nodeId)), new Uint256(amount)));
        return function;
    }

    public RemoteCall<TransactionResponse> unDelegate(String nodeId, BigInteger stakingBlockNum, BigInteger amount) {
        Function function = this.createUnDelegateFunction(nodeId, stakingBlockNum, amount);
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionResponse> unDelegate(String nodeId, BigInteger stakingBlockNum, BigInteger amount, GasProvider gasProvider) {
        Function function = this.createUnDelegateFunction(nodeId, stakingBlockNum, amount);
        return this.executeRemoteCallTransaction(function, gasProvider);
    }

    public GasProvider getUnDelegateGasProvider(String nodeId, BigInteger stakingBlockNum, BigInteger amount) throws IOException, EstimateGasException, NoSupportFunctionType {
        Function function = this.createUnDelegateFunction(nodeId, stakingBlockNum, amount);
        return this.getDefaultGasProvider(function);
    }

    public RemoteCall<PlatonSendTransaction> unDelegateReturnTransaction(String nodeId, BigInteger stakingBlockNum, BigInteger amount) {
        Function function = this.createUnDelegateFunction(nodeId, stakingBlockNum, amount);
        return this.executeRemoteCallTransactionStep1(function);
    }

    public RemoteCall<PlatonSendTransaction> unDelegateReturnTransaction(String nodeId, BigInteger stakingBlockNum, BigInteger amount, GasProvider gasProvider) {
        Function function = this.createUnDelegateFunction(nodeId, stakingBlockNum, amount);
        return this.executeRemoteCallTransactionStep1(function, gasProvider);
    }

    private Function createUnDelegateFunction(String nodeId, BigInteger stakingBlockNum, BigInteger amount) {
        Function function = new Function(1005, Arrays.asList(new Uint64(stakingBlockNum), new BytesType(Numeric.hexStringToByteArray((String)nodeId)), new Uint256(amount)));
        return function;
    }

    public BigInteger decodeUnDelegateLog(TransactionReceipt transactionReceipt) throws TransactionException {
        List<Log> logs = transactionReceipt.getLogs();
        if (logs == null || logs.isEmpty()) {
            throw new TransactionException("TransactionReceipt logs is empty");
        }
        String logData = logs.get(0).getData();
        if (null == logData || "".equals(logData)) {
            throw new TransactionException("TransactionReceipt logs[0].data is empty");
        }
        RlpList rlp = RlpDecoder.decode((byte[])Numeric.hexStringToByteArray((String)logData));
        List rlpList = ((RlpList)rlp.getValues().get(0)).getValues();
        String decodedStatus = new String(((RlpString)rlpList.get(0)).getBytes());
        int statusCode = Integer.parseInt(decodedStatus);
        if (statusCode != 0) {
            throw new TransactionException("TransactionResponse code is 0");
        }
        return ((RlpString)RlpDecoder.decode((byte[])((RlpString)rlpList.get(1)).getBytes()).getValues().get(0)).asPositiveBigInteger();
    }

    public RemoteCall<CallResponse<Delegation>> getDelegateInfo(String nodeId, String delAddr, BigInteger stakingBlockNum) {
        Function function = new Function(1104, Arrays.asList(new Uint64(stakingBlockNum), new BytesType(Bech32.addressDecode((String)delAddr)), new BytesType(Numeric.hexStringToByteArray((String)nodeId))));
        return this.executeRemoteCallObjectValueReturn(function, Delegation.class);
    }

    public RemoteCall<CallResponse<List<DelegationIdInfo>>> getRelatedListByDelAddr(String address) {
        Function function = new Function(1103, Arrays.asList(new BytesType(Bech32.addressDecode((String)address))));
        return this.executeRemoteCallListValueReturn(function, DelegationIdInfo.class);
    }
}

