/*
 * Decompiled with CFR 0.152.
 */
package com.platon.protocol.admin;

import com.platon.protocol.Web3jService;
import com.platon.protocol.admin.Admin;
import com.platon.protocol.admin.methods.response.NewAccountIdentifier;
import com.platon.protocol.admin.methods.response.PersonalListAccounts;
import com.platon.protocol.admin.methods.response.PersonalUnlockAccount;
import com.platon.protocol.core.JsonRpc2_0Web3j;
import com.platon.protocol.core.Request;
import com.platon.protocol.core.methods.request.Transaction;
import com.platon.protocol.core.methods.response.PlatonSendTransaction;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ScheduledExecutorService;

public class JsonRpc2_0Admin
extends JsonRpc2_0Web3j
implements Admin {
    public JsonRpc2_0Admin(Web3jService web3jService) {
        super(web3jService);
    }

    public JsonRpc2_0Admin(Web3jService web3jService, long pollingInterval, ScheduledExecutorService scheduledExecutorService) {
        super(web3jService, pollingInterval, scheduledExecutorService);
    }

    @Override
    public Request<?, PersonalListAccounts> personalListAccounts() {
        return new Request("personal_listAccounts", Collections.emptyList(), this.web3jService, PersonalListAccounts.class);
    }

    @Override
    public Request<?, NewAccountIdentifier> personalNewAccount(String password) {
        return new Request<String, NewAccountIdentifier>("personal_newAccount", Arrays.asList(password), this.web3jService, NewAccountIdentifier.class);
    }

    @Override
    public Request<?, PersonalUnlockAccount> personalUnlockAccount(String accountId, String password, BigInteger duration) {
        ArrayList<Object> attributes = new ArrayList<Object>(3);
        attributes.add(accountId);
        attributes.add(password);
        if (duration != null) {
            attributes.add(duration.longValue());
        } else {
            attributes.add(null);
        }
        return new Request("personal_unlockAccount", attributes, this.web3jService, PersonalUnlockAccount.class);
    }

    @Override
    public Request<?, PersonalUnlockAccount> personalUnlockAccount(String accountId, String password) {
        return this.personalUnlockAccount(accountId, password, null);
    }

    @Override
    public Request<?, PlatonSendTransaction> personalSendTransaction(Transaction transaction, String passphrase) {
        return new Request<Object, PlatonSendTransaction>("personal_sendTransaction", Arrays.asList(transaction, passphrase), this.web3jService, PlatonSendTransaction.class);
    }
}

