/*
 * Decompiled with CFR 0.152.
 */
package com.platon.console;

import com.platon.codegen.Console;
import com.platon.console.IODevice;
import com.platon.console.WalletManager;
import com.platon.crypto.CipherException;
import com.platon.crypto.WalletUtils;
import java.io.File;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

public class WalletCreator
extends WalletManager {
    public WalletCreator() {
    }

    public WalletCreator(IODevice console) {
        super(console);
    }

    public static void main(String[] args) {
        new WalletCreator().run();
    }

    static void main(IODevice console) {
        new WalletCreator(console).run();
    }

    private void run() {
        String password = this.getPassword("Please enter a wallet file password: ");
        String destinationDir = this.getDestinationDir();
        File destination = this.createDir(destinationDir);
        try {
            String walletFileName = WalletUtils.generateFullNewWalletFile((String)password, (File)destination);
            this.console.printf("Wallet file " + walletFileName + " successfully created in: " + destinationDir + "\n", new Object[0]);
        }
        catch (CipherException | IOException | InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException e) {
            Console.exitError((Throwable)e);
        }
    }
}

