/*
 * Decompiled with CFR 0.152.
 */
package com.platon.rlp.wasm.datatypes;

import com.platon.rlp.wasm.datatypes.Int;
import java.math.BigInteger;

public class Int8
extends Int {
    public byte value;
    public static final int size = 64;

    private Int8(byte value) {
        this.value = value;
        this.unsingedValue = new BigInteger(Long.toUnsignedString(Int8.encodeZigZag64(value)));
    }

    private Int8(BigInteger unsingedValue) {
        this.unsingedValue = unsingedValue;
        this.value = (byte)Int8.decodeZigZag64(unsingedValue.longValue());
    }

    public static Int8 of(long value) {
        if (BigInteger.valueOf(value).bitLength() >= 8) {
            throw new UnsupportedOperationException("Data length overflow, Bitsize must be in range 0 < bitSize < 8");
        }
        return new Int8((byte)value);
    }

    public static Int8 ofUnsignedValue(BigInteger unsingedValue) {
        return new Int8(unsingedValue);
    }

    public static Int8 of(BigInteger value) {
        if (value.bitLength() >= 8) {
            throw new UnsupportedOperationException("Data length overflow, Bitsize must be in range 0 < bitSize < 8");
        }
        return new Int8(Int8.encodeZigZag(value, 64));
    }

    public byte getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Int8 that = (Int8)o;
        return this.value == that.value;
    }

    public String toString() {
        return Long.valueOf(this.value).toString();
    }
}

