/*
 * Decompiled with CFR 0.152.
 */
package com.platon.console;

import com.platon.codegen.Console;
import com.platon.console.ConsoleDevice;
import com.platon.console.IODevice;
import com.platon.crypto.CipherException;
import com.platon.crypto.Credentials;
import com.platon.crypto.WalletUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

abstract class WalletManager {
    final IODevice console;

    WalletManager() {
        this.console = new ConsoleDevice();
        if (this.console == null) {
            Console.exitError((String)"Unable to access console - please ensure you are running from the command line");
        }
    }

    WalletManager(IODevice console) {
        this.console = console;
    }

    String getPassword(String initialPrompt) {
        char[] input2;
        char[] input1;
        while (!Arrays.equals(input1 = this.console.readPassword(initialPrompt, new Object[0]), input2 = this.console.readPassword("Please re-enter the password: ", new Object[0]))) {
            this.console.printf("Sorry, passwords did not match\n", new Object[0]);
        }
        return new String(input1);
    }

    String getDestinationDir() {
        String defaultDir = WalletUtils.getTestnetKeyDirectory();
        String destinationDir = this.console.readLine("Please enter a destination directory location [" + defaultDir + "]: ", new Object[0]);
        if (destinationDir.equals("")) {
            return defaultDir;
        }
        if (destinationDir.startsWith("~")) {
            return System.getProperty("user.home") + destinationDir.substring(1);
        }
        return destinationDir;
    }

    File createDir(String destinationDir) {
        File destination = new File(destinationDir);
        if (!destination.exists()) {
            this.console.printf("Creating directory: " + destinationDir + " ...", new Object[0]);
            if (!destination.mkdirs()) {
                Console.exitError((String)("Unable to create destination directory [" + destinationDir + "], exiting..."));
            } else {
                this.console.printf("complete\n", new Object[0]);
            }
        }
        return destination;
    }

    Credentials getCredentials(File walletFile) {
        if (!walletFile.exists() || !walletFile.isFile()) {
            Console.exitError((String)("Unable to read wallet file: " + walletFile));
        }
        return this.loadWalletFile(walletFile);
    }

    private Credentials loadWalletFile(File walletFile) {
        while (true) {
            char[] password = this.console.readPassword("Please enter your existing wallet file password: ", new Object[0]);
            String currentPassword = new String(password);
            try {
                return WalletUtils.loadCredentials((String)currentPassword, (File)walletFile);
            }
            catch (CipherException e) {
                this.console.printf("Invalid password specified\n", new Object[0]);
                continue;
            }
            catch (IOException e) {
                Console.exitError((String)("Unable to load wallet file: " + walletFile + "\n" + e.getMessage()));
                continue;
            }
            break;
        }
    }
}

