/*
 * Decompiled with CFR 0.152.
 */
package com.platon.crypto;

import com.platon.bech32.Bech32;
import com.platon.crypto.RawTransaction;
import com.platon.crypto.Sign;
import com.platon.crypto.SignedRawTransaction;
import com.platon.parameters.NetworkParameters;
import com.platon.rlp.solidity.RlpDecoder;
import com.platon.rlp.solidity.RlpList;
import com.platon.rlp.solidity.RlpString;
import com.platon.utils.Numeric;
import java.math.BigInteger;

public class TransactionDecoder {
    private static final int CHAIN_ID_INC = 35;
    private static final int LOWER_REAL_V = 27;

    public static RawTransaction decode(String hexTransaction) {
        byte[] transaction = Numeric.hexStringToByteArray((String)hexTransaction);
        RlpList rlpList = RlpDecoder.decode((byte[])transaction);
        RlpList values = (RlpList)rlpList.getValues().get(0);
        BigInteger nonce = ((RlpString)values.getValues().get(0)).asPositiveBigInteger();
        BigInteger gasPrice = ((RlpString)values.getValues().get(1)).asPositiveBigInteger();
        BigInteger gasLimit = ((RlpString)values.getValues().get(2)).asPositiveBigInteger();
        String to = ((RlpString)values.getValues().get(3)).asString();
        BigInteger value = ((RlpString)values.getValues().get(4)).asPositiveBigInteger();
        String data = ((RlpString)values.getValues().get(5)).asString();
        if (values.getValues().size() == 6 || values.getValues().size() == 8 && ((RlpString)values.getValues().get(7)).getBytes().length == 10 || values.getValues().size() == 9 && ((RlpString)values.getValues().get(8)).getBytes().length == 10) {
            return RawTransaction.createTransaction(nonce, gasPrice, gasLimit, to, value, data);
        }
        byte[] v = ((RlpString)values.getValues().get(6)).getBytes();
        byte[] r = Numeric.toBytesPadded((BigInteger)Numeric.toBigInt((byte[])((RlpString)values.getValues().get(7)).getBytes()), (int)32);
        byte[] s = Numeric.toBytesPadded((BigInteger)Numeric.toBigInt((byte[])((RlpString)values.getValues().get(8)).getBytes()), (int)32);
        Sign.SignatureData signatureData = new Sign.SignatureData(v, r, s);
        return new SignedRawTransaction(nonce, gasPrice, gasLimit, Bech32.addressEncode((String)NetworkParameters.getHrp(), (String)to), value, data, signatureData);
    }

    public static Long getChainId(byte[] inputV) {
        BigInteger bv = Numeric.toBigInt((byte[])inputV);
        long v = bv.longValue();
        if (v == 27L || v == 28L) {
            return null;
        }
        return (v - 35L) / 2L;
    }
}

