/*
 * Decompiled with CFR 0.152.
 */
package com.platon.abi.solidity.datatypes;

import com.platon.abi.solidity.datatypes.Type;
import com.platon.abi.solidity.datatypes.generated.Uint160;
import com.platon.bech32.Bech32;
import com.platon.parameters.NetworkParameters;
import com.platon.utils.Numeric;
import java.math.BigInteger;

public class Address
implements Type<String> {
    public static final String TYPE_NAME = "address";
    public static final int LENGTH = 160;
    public static final int LENGTH_IN_HEX = 40;
    private final Uint160 value;
    private final String address;

    public Address(Uint160 value) {
        this(value, NetworkParameters.getHrp());
    }

    public Address(Uint160 value, String hrp) {
        this.value = value;
        this.address = Bech32.addressEncode((String)hrp, (String)Numeric.toHexStringWithPrefixZeroPadded((BigInteger)value.getValue(), (int)40));
    }

    public Address(BigInteger inputValue) {
        this.value = new Uint160(inputValue);
        this.address = Bech32.addressEncode((String)NetworkParameters.getHrp(), (String)Numeric.toHexStringWithPrefixZeroPadded((BigInteger)inputValue, (int)40));
    }

    public Address(String bechValue) {
        this.value = new Uint160(Numeric.toBigInt((String)Bech32.addressDecodeHex((String)bechValue)));
        this.address = bechValue;
    }

    public Uint160 toUint160() {
        return this.value;
    }

    @Override
    public String getTypeAsString() {
        return TYPE_NAME;
    }

    public String toString() {
        return this.address;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return this.value != null ? this.value.equals(address.value) : address.value == null;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }
}

