/*
 * Decompiled with CFR 0.152.
 */
package com.platon.rlp.wasm;

import com.platon.rlp.wasm.CollectionContainer;
import com.platon.rlp.wasm.ContainerType;
import com.platon.rlp.wasm.MapContainer;
import com.platon.rlp.wasm.PairContainer;
import com.platon.rlp.wasm.RLPDecoding;
import com.platon.rlp.wasm.Raw;
import com.platon.rlp.wasm.datatypes.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public interface Container<V> {
    public static final Set<Class<? extends Map>> SUPPORTED_MAPS = new HashSet<Class>(Arrays.asList(Map.class, HashMap.class, ConcurrentMap.class, ConcurrentHashMap.class, TreeMap.class));
    public static final Set<Class<? extends Collection>> SUPPORTED_COLLECTIONS = new HashSet<Class>(Arrays.asList(Collection.class, List.class, ArrayList.class, Set.class, Queue.class, Deque.class, HashSet.class, TreeSet.class, LinkedList.class, ArrayDeque.class));

    public static Container<?> fromField(Field field) {
        Container container = Container.fromType(field.getGenericType());
        Class<?> clazz = null;
        if (field.isAnnotationPresent(RLPDecoding.class)) {
            clazz = field.getAnnotation(RLPDecoding.class).as();
        }
        if (clazz == null || clazz == Void.class) {
            return container;
        }
        if (!Collection.class.isAssignableFrom(clazz) && !Map.class.isAssignableFrom(clazz)) {
            throw new RuntimeException("@RLPDecoding.as must be a collection of map type while " + clazz.getName() + " found");
        }
        if (container.getType() == ContainerType.RAW) {
            throw new RuntimeException("@RLPDecoding.as is used on collection or map typed field other than " + field.getName());
        }
        if (!field.getType().isAssignableFrom(clazz)) {
            throw new RuntimeException("cannot assign " + clazz + " to " + field.getType());
        }
        if (container.getType() == ContainerType.COLLECTION) {
            container.asCollection().collectionType = clazz;
        }
        if (container.getType() == ContainerType.MAP) {
            container.asMap().mapType = clazz;
        }
        return container;
    }

    public static Container fromClass(Class clazz) {
        if (Collection.class.isAssignableFrom(clazz)) {
            if (!SUPPORTED_COLLECTIONS.contains(clazz)) {
                throw new RuntimeException(clazz + " is not supported, please use one of type " + SUPPORTED_COLLECTIONS.stream().map(x -> x.getName()).reduce("", String::concat));
            }
            return new CollectionContainer(clazz);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            if (!SUPPORTED_MAPS.contains(clazz)) {
                throw new RuntimeException(clazz + " is not supported, please use one of type " + SUPPORTED_MAPS.stream().map(x -> x.getName()).reduce("", String::concat));
            }
            return new MapContainer(clazz);
        }
        if (Pair.class.isAssignableFrom(clazz)) {
            return new PairContainer(clazz);
        }
        return new Raw(clazz);
    }

    public static Container fromType(Type type) {
        if (type instanceof Class) {
            return Container.fromClass((Class)type);
        }
        if (!(type instanceof ParameterizedType)) {
            throw new RuntimeException("type variable " + type + " is not allowed in rlp decoding");
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] types = parameterizedType.getActualTypeArguments();
        Class clazz = (Class)parameterizedType.getRawType();
        Container container = Container.fromClass(clazz);
        switch (container.getType()) {
            case RAW: {
                return container;
            }
            case MAP: {
                MapContainer con = container.asMap();
                con.keyType = Container.fromType(types[0]);
                con.valueType = Container.fromType(types[1]);
                return con;
            }
            case COLLECTION: {
                CollectionContainer con = container.asCollection();
                con.contentType = Container.fromType(types[0]);
                return con;
            }
            case PAIR: {
                PairContainer pair = container.asPair();
                pair.keyType = Container.fromType(types[0]);
                pair.valueType = Container.fromType(types[1]);
                return pair;
            }
        }
        throw new RuntimeException("this is unreachable");
    }

    public ContainerType getType();

    public Class<V> asRaw();

    public CollectionContainer<? extends Collection<V>, V> asCollection();

    public MapContainer<? extends Map<?, V>, ?, V> asMap();

    public PairContainer<? extends Pair<?, V>, ?, V> asPair();
}

