/*
 * Decompiled with CFR 0.152.
 */
package com.platon.rlp.wasm;

import java.util.Arrays;

final class LazyByteArray {
    private byte[] data;
    private int offset;
    private int limit;
    static LazyByteArray EMPTY = new LazyByteArray(new byte[0]);

    LazyByteArray(byte[] data) {
        this.data = data;
        this.limit = data.length;
    }

    LazyByteArray(byte[] data, int offset, int limit) {
        this.data = data;
        this.offset = offset;
        this.limit = limit;
    }

    byte[] get() {
        if (this.offset == 0 && this.limit == this.data.length) {
            return this.data;
        }
        this.data = Arrays.copyOfRange(this.data, this.offset, this.limit);
        this.offset = 0;
        this.limit = this.data.length;
        return this.data;
    }

    int size() {
        return this.limit - this.offset;
    }
}

