/*
 * Decompiled with CFR 0.152.
 */
package com.platon.rlp.wasm;

import com.platon.rlp.wasm.CollectionContainer;
import com.platon.rlp.wasm.Container;
import com.platon.rlp.wasm.ContainerType;
import com.platon.rlp.wasm.PairContainer;
import com.platon.rlp.wasm.datatypes.Pair;
import java.util.Collection;
import java.util.Map;

public class MapContainer<M extends Map<K, V>, K, V>
implements Container<V> {
    Class mapType;
    public Container keyType;
    public Container valueType;

    @Override
    public ContainerType getType() {
        return ContainerType.MAP;
    }

    public MapContainer(Class mapType) {
        this.mapType = mapType;
    }

    @Override
    public Class<V> asRaw() {
        throw new RuntimeException("not a raw type");
    }

    @Override
    public CollectionContainer<? extends Collection<V>, V> asCollection() {
        throw new RuntimeException("not a collection container");
    }

    @Override
    public MapContainer<? extends Map<?, V>, ?, V> asMap() {
        return this;
    }

    @Override
    public PairContainer<? extends Pair<?, V>, ?, V> asPair() {
        throw new RuntimeException("not a pair container");
    }

    public static <M extends Map<K, V>, K, V> MapContainerBuilder<M, K, V> builder() {
        return new MapContainerBuilder();
    }

    public MapContainer() {
    }

    public MapContainer(Class mapType, Container keyType, Container valueType) {
        this.mapType = mapType;
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public static class MapContainerBuilder<M extends Map<K, V>, K, V> {
        private Class mapType;
        private Container keyType;
        private Container valueType;

        MapContainerBuilder() {
        }

        public MapContainerBuilder<M, K, V> mapType(Class mapType) {
            this.mapType = mapType;
            return this;
        }

        public MapContainerBuilder<M, K, V> keyType(Container keyType) {
            this.keyType = keyType;
            return this;
        }

        public MapContainerBuilder<M, K, V> valueType(Container valueType) {
            this.valueType = valueType;
            return this;
        }

        public MapContainer<M, K, V> build() {
            return new MapContainer(this.mapType, this.keyType, this.valueType);
        }

        public String toString() {
            return "MapContainer.MapContainerBuilder(mapType=" + this.mapType + ", keyType=" + this.keyType + ", valueType=" + this.valueType + ")";
        }
    }
}

