/*
 * Decompiled with CFR 0.152.
 */
package com.platon.rlp.wasm;

import com.platon.rlp.wasm.LazyByteArray;
import com.platon.rlp.wasm.RLPCodec;
import com.platon.rlp.wasm.RLPElement;
import com.platon.rlp.wasm.RLPList;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class RLPItem
implements RLPElement {
    private static byte[] NULL_ENCODED = RLPCodec.encodeBytes(null);
    public static final RLPItem ONE = new RLPItem(new LazyByteArray(new byte[]{1}));
    private LazyByteArray data;
    private Long longNumber;
    private LazyByteArray encoded;
    public static final RLPItem NULL = new RLPItem(LazyByteArray.EMPTY);

    void setEncoded(LazyByteArray encoded) {
        this.encoded = encoded;
    }

    @Override
    public byte[] asBytes() {
        return this.data.get();
    }

    public static RLPItem fromByte(byte b) {
        return RLPItem.fromLong(Byte.toUnsignedLong(b));
    }

    public static RLPItem fromShort(short s) {
        return RLPItem.fromLong(Short.toUnsignedLong(s));
    }

    public static RLPItem fromBoolean(boolean b) {
        return b ? ONE : NULL;
    }

    public static RLPItem fromInt(int i) {
        return RLPItem.fromLong(Integer.toUnsignedLong(i));
    }

    public static RLPItem fromLong(long l) {
        if (l == 0L) {
            return NULL;
        }
        if (l == 1L) {
            return ONE;
        }
        int leadingZeroBytes = Long.numberOfLeadingZeros(l) / 8;
        return RLPItem.fromBytes(RLPItem.concat(new byte[][]{Arrays.copyOfRange(ByteBuffer.allocate(8).putLong(l).array(), leadingZeroBytes, 8)}));
    }

    public static RLPItem fromString(String s) {
        if (s == null) {
            return NULL;
        }
        return RLPItem.fromBytes(s.getBytes(StandardCharsets.UTF_8));
    }

    public static RLPItem fromBytes(byte[] data) {
        if (data == null || data.length == 0) {
            return NULL;
        }
        if (data.length == 1 && Byte.toUnsignedInt(data[0]) == 1) {
            return ONE;
        }
        return new RLPItem(new LazyByteArray(data));
    }

    public static RLPItem fromBigInteger(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.equals(BigInteger.ZERO)) {
            return NULL;
        }
        if (bigInteger.equals(BigInteger.ONE)) {
            return ONE;
        }
        if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
            throw new RuntimeException("negative numbers are not allowed");
        }
        return RLPItem.fromBytes(RLPItem.asUnsignedByteArray(bigInteger));
    }

    private static byte[] asUnsignedByteArray(BigInteger value) {
        byte[] bytes = value.toByteArray();
        if (bytes[0] == 0) {
            byte[] tmp = new byte[bytes.length - 1];
            System.arraycopy(bytes, 1, tmp, 0, tmp.length);
            return tmp;
        }
        return bytes;
    }

    RLPItem(LazyByteArray data) {
        this.data = data;
    }

    @Override
    public boolean isRLPList() {
        return false;
    }

    @Override
    public RLPList asRLPList() {
        throw new RuntimeException("not a rlp list");
    }

    @Override
    public RLPItem asRLPItem() {
        return this;
    }

    @Override
    public boolean isNull() {
        return this == NULL || this.data.size() == 0;
    }

    @Override
    public byte asByte() {
        if (Long.compareUnsigned(this.asLong(), 255L) > 0) {
            throw new RuntimeException("invalid byte, overflow");
        }
        return (byte)this.asLong();
    }

    @Override
    public short asShort() {
        if (Long.compareUnsigned(this.asLong(), 65535L) > 0) {
            throw new RuntimeException("invalid short, overflow");
        }
        return (short)this.asLong();
    }

    @Override
    public int asInt() {
        if (Long.compareUnsigned(this.asLong(), -1L) > 0) {
            throw new RuntimeException("invalid int, overflow");
        }
        return (int)this.asLong();
    }

    @Override
    public long asLong() {
        if (this.isNull()) {
            return 0L;
        }
        if (this == ONE) {
            return 1L;
        }
        if (this.longNumber != null) {
            return this.longNumber;
        }
        byte[] data = this.asBytes();
        if (data.length > 0 && data[0] == 0) {
            throw new RuntimeException("not a number");
        }
        if (data.length > 8) {
            throw new RuntimeException("not a number");
        }
        this.longNumber = ByteBuffer.wrap(RLPItem.concat(new byte[8 - data.length], data)).getLong();
        return this.longNumber;
    }

    @Override
    public BigInteger asBigInteger() {
        if (this.isNull()) {
            return BigInteger.ZERO;
        }
        if (this == ONE) {
            return BigInteger.ONE;
        }
        byte[] data = this.asBytes();
        if (data[0] == 0) {
            throw new RuntimeException("not a number");
        }
        return new BigInteger(1, data);
    }

    @Override
    public String asString() {
        if (this.isNull()) {
            return "";
        }
        return new String(this.asBytes(), StandardCharsets.UTF_8);
    }

    @Override
    public boolean asBoolean() {
        if (this.asLong() > 1L) {
            throw new RuntimeException("not a boolean");
        }
        return this.asLong() == 1L;
    }

    @Override
    public byte[] getEncoded() {
        if (this.isNull()) {
            return NULL_ENCODED;
        }
        if (this.encoded == null) {
            this.encoded = new LazyByteArray(RLPCodec.encodeBytes(this.asBytes()));
        }
        return this.encoded.get();
    }

    private static byte[] concat(byte[] ... arrays) {
        int length = 0;
        for (byte[] array : arrays) {
            length += array.length;
        }
        byte[] result = new byte[length];
        int pos = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, result, pos, array.length);
            pos += array.length;
        }
        return result;
    }

    @Override
    public boolean isRLPItem() {
        return true;
    }

    @Override
    public RLPElement get(int index) {
        throw new RuntimeException("not a rlp list");
    }

    @Override
    public boolean add(RLPElement element) {
        throw new RuntimeException("not a rlp list");
    }

    @Override
    public RLPElement set(int index, RLPElement element) {
        throw new RuntimeException("not a rlp list");
    }

    @Override
    public int size() {
        throw new RuntimeException("not a rlp list");
    }

    public static RLPItemBuilder builder() {
        return new RLPItemBuilder();
    }

    public RLPItem(LazyByteArray data, Long longNumber, LazyByteArray encoded) {
        this.data = data;
        this.longNumber = longNumber;
        this.encoded = encoded;
    }

    public static class RLPItemBuilder {
        private LazyByteArray data;
        private Long longNumber;
        private LazyByteArray encoded;

        RLPItemBuilder() {
        }

        public RLPItemBuilder data(LazyByteArray data) {
            this.data = data;
            return this;
        }

        public RLPItemBuilder longNumber(Long longNumber) {
            this.longNumber = longNumber;
            return this;
        }

        public RLPItemBuilder encoded(LazyByteArray encoded) {
            this.encoded = encoded;
            return this;
        }

        public RLPItem build() {
            return new RLPItem(this.data, this.longNumber, this.encoded);
        }

        public String toString() {
            return "RLPItem.RLPItemBuilder(data=" + this.data + ", longNumber=" + this.longNumber + ", encoded=" + this.encoded + ")";
        }
    }
}

