/*
 * Decompiled with CFR 0.152.
 */
package com.platon.rlp.wasm;

import com.platon.rlp.wasm.LazyByteArray;
import com.platon.rlp.wasm.LazyElement;
import com.platon.rlp.wasm.RLPElement;
import com.platon.rlp.wasm.RLPItem;
import com.platon.rlp.wasm.RLPList;
import java.math.BigInteger;
import java.util.Arrays;

final class RLPParser {
    private byte[] raw;
    private int offset;
    private int limit;

    private static int byteArrayToInt(byte[] b) {
        if (b == null || b.length == 0) {
            return 0;
        }
        return new BigInteger(1, b).intValue();
    }

    static RLPElement fromEncoded(byte[] data, boolean lazy) {
        RLPParser parser = new RLPParser(data);
        if (parser.estimateSize() != data.length) {
            throw new RuntimeException("invalid encoding");
        }
        return lazy ? parser.readLazy() : parser.readElement();
    }

    private RLPParser(byte[] data) {
        this.raw = data;
        this.limit = data.length;
    }

    private RLPParser(byte[] data, int offset, int limit) {
        this.raw = data;
        this.offset = offset;
        this.limit = limit;
    }

    private RLPParser readAsParser(int length) {
        if (this.offset + length > this.limit) {
            throw new RuntimeException("read overflow");
        }
        RLPParser parser = new RLPParser(this.raw, this.offset, this.offset + length);
        this.offset += length;
        return parser;
    }

    private int estimateSize() {
        int prefix = this.peek();
        if (prefix < 128) {
            return 1;
        }
        if (prefix <= 183) {
            return prefix - 128 + 1;
        }
        if (prefix < 192) {
            return RLPParser.byteArrayToInt(Arrays.copyOfRange(this.raw, this.offset + 1, this.offset + 1 + prefix - 183)) + 1 + prefix - 183;
        }
        if (prefix <= 247) {
            return prefix - 192 + 1;
        }
        return RLPParser.byteArrayToInt(Arrays.copyOfRange(this.raw, this.offset + 1, this.offset + 1 + prefix - 247)) + 1 + prefix - 247;
    }

    private int read() {
        if (this.offset >= this.limit) {
            throw new RuntimeException("read overflow");
        }
        return Byte.toUnsignedInt(this.raw[this.offset++]);
    }

    private byte[] read(int n) {
        if (this.offset + n > this.limit) {
            throw new RuntimeException("read overflow");
        }
        byte[] res = Arrays.copyOfRange(this.raw, this.offset, this.offset + n);
        this.offset += n;
        return res;
    }

    private void skip(int n) {
        this.offset += n;
    }

    private int peek() {
        return Byte.toUnsignedInt(this.raw[this.offset]);
    }

    boolean peekIsList() {
        return this.peek() >= 192;
    }

    private RLPList readList(boolean lazy) {
        RLPParser parser;
        int offset = this.offset;
        int prefix = this.read();
        RLPList list = RLPList.createEmpty();
        if (prefix <= 247) {
            int len = prefix - 192;
            if (len == 0) {
                return list;
            }
            parser = this.readAsParser(len);
        } else {
            int lenlen = prefix - 247;
            int lenlist = RLPParser.byteArrayToInt(this.read(lenlen));
            parser = this.readAsParser(lenlist);
        }
        int limit = parser.limit;
        while (parser.hasRemaining()) {
            list.add(lazy ? parser.readLazyElement() : parser.readElement());
        }
        list.setEncoded(new LazyByteArray(this.raw, offset, limit));
        return list;
    }

    RLPElement readElement() {
        if (this.peekIsList()) {
            return this.readList(false);
        }
        return this.readItem();
    }

    RLPElement readLazy() {
        if (this.peekIsList()) {
            return this.readList(true);
        }
        return this.readItem();
    }

    LazyElement readLazyElement() {
        return new LazyElement(this.readAsParser(this.estimateSize()));
    }

    private RLPItem readItem() {
        int initOffset = this.offset;
        int prefix = this.read();
        if (prefix < 128) {
            return RLPItem.fromBytes(new byte[]{(byte)prefix});
        }
        if (prefix <= 183) {
            int length = prefix - 128;
            if (length == 0) {
                return RLPItem.NULL;
            }
            RLPItem item = new RLPItem(new LazyByteArray(this.raw, this.offset, this.offset + length));
            this.skip(length);
            return item;
        }
        int lengthBits = prefix - 183;
        int length = RLPParser.byteArrayToInt(this.read(lengthBits));
        int stopLimit = this.limit;
        RLPItem item = new RLPItem(new LazyByteArray(this.raw, this.offset, this.offset + length));
        item.setEncoded(new LazyByteArray(this.raw, initOffset, stopLimit));
        this.skip(length);
        return item;
    }

    private boolean hasRemaining() {
        return this.offset < this.limit;
    }

    LazyByteArray getLazyByteArray() {
        return new LazyByteArray(this.raw, this.offset, this.limit);
    }
}

