/*
 * Decompiled with CFR 0.152.
 */
package com.platon.rlp.wasm.datatypes;

import com.platon.rlp.wasm.datatypes.Int;
import java.math.BigInteger;

public class Int128
extends Int {
    public BigInteger value;
    public static final int size = 128;

    private Int128(long value) {
        this.value = BigInteger.valueOf(value);
        this.unsingedValue = Int128.encodeZigZag(this.value, 128);
    }

    private Int128(BigInteger unsingedValue) {
        this.unsingedValue = unsingedValue;
        this.value = Int128.decodeZigZag(this.unsingedValue);
    }

    public static Int128 of(long value) {
        return new Int128(value);
    }

    public static Int128 ofUnsignedValue(BigInteger value) {
        return new Int128(value);
    }

    public static Int128 of(BigInteger value) {
        if (value.bitLength() >= 128) {
            throw new UnsupportedOperationException("Data length overflow, Bitsize must be in range 0 < bitSize < 128");
        }
        return new Int128(Int128.encodeZigZag(value, 128));
    }

    public BigInteger getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Int128 that = (Int128)o;
        return this.value == that.value;
    }

    public String toString() {
        return this.value.toString();
    }
}

