/*
 * Decompiled with CFR 0.152.
 */
package com.platon.contracts.ppos;

import com.platon.abi.solidity.datatypes.BytesType;
import com.platon.bech32.Bech32;
import com.platon.contracts.ppos.BaseContract;
import com.platon.contracts.ppos.abi.CustomStaticArray;
import com.platon.contracts.ppos.abi.Function;
import com.platon.contracts.ppos.abi.custom.NodeId;
import com.platon.contracts.ppos.dto.CallResponse;
import com.platon.contracts.ppos.dto.TransactionResponse;
import com.platon.contracts.ppos.dto.resp.Reward;
import com.platon.contracts.ppos.exception.EstimateGasException;
import com.platon.contracts.ppos.exception.NoSupportFunctionType;
import com.platon.crypto.Credentials;
import com.platon.parameters.NetworkParameters;
import com.platon.protocol.Web3j;
import com.platon.protocol.core.RemoteCall;
import com.platon.protocol.core.methods.response.Log;
import com.platon.protocol.core.methods.response.PlatonSendTransaction;
import com.platon.protocol.core.methods.response.TransactionReceipt;
import com.platon.protocol.exceptions.TransactionException;
import com.platon.rlp.solidity.RlpDecoder;
import com.platon.rlp.solidity.RlpList;
import com.platon.rlp.solidity.RlpString;
import com.platon.tx.TransactionManager;
import com.platon.tx.gas.GasProvider;
import com.platon.utils.Numeric;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class RewardContract
extends BaseContract {
    public static RewardContract load(Web3j web3j) {
        return new RewardContract(NetworkParameters.getPposContractAddressOfReward(), web3j);
    }

    public static RewardContract load(Web3j web3j, TransactionManager transactionManager) {
        return new RewardContract(NetworkParameters.getPposContractAddressOfReward(), web3j, transactionManager);
    }

    public static RewardContract load(Web3j web3j, Credentials credentials) {
        return new RewardContract(NetworkParameters.getPposContractAddressOfReward(), web3j, credentials);
    }

    private RewardContract(String contractAddress, Web3j web3j) {
        super(contractAddress, web3j);
    }

    private RewardContract(String contractAddress, Web3j web3j, Credentials credentials) {
        super(contractAddress, web3j, credentials);
    }

    private RewardContract(String contractAddress, Web3j web3j, TransactionManager transactionManager) {
        super(contractAddress, web3j, transactionManager);
    }

    public RemoteCall<TransactionResponse> withdrawDelegateReward() {
        Function function = this.createWithdrawDelegateRewardFunction();
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionResponse> withdrawDelegateReward(GasProvider gasProvider) {
        Function function = this.createWithdrawDelegateRewardFunction();
        return this.executeRemoteCallTransaction(function, gasProvider);
    }

    public GasProvider getWithdrawDelegateRewardGasProvider() throws IOException, EstimateGasException, NoSupportFunctionType {
        Function function = this.createWithdrawDelegateRewardFunction();
        return this.getDefaultGasProvider(function);
    }

    public RemoteCall<PlatonSendTransaction> withdrawDelegateRewardReturnTransaction() {
        Function function = this.createWithdrawDelegateRewardFunction();
        return this.executeRemoteCallTransactionStep1(function);
    }

    public RemoteCall<PlatonSendTransaction> withdrawDelegateRewardReturnTransaction(GasProvider gasProvider) {
        Function function = this.createWithdrawDelegateRewardFunction();
        return this.executeRemoteCallTransactionStep1(function, gasProvider);
    }

    private Function createWithdrawDelegateRewardFunction() {
        Function function = new Function(5000);
        return function;
    }

    public List<Reward> decodeWithdrawDelegateRewardLog(TransactionReceipt transactionReceipt) throws TransactionException {
        List<Log> logs = transactionReceipt.getLogs();
        if (logs == null || logs.isEmpty()) {
            throw new TransactionException("TransactionReceipt logs is empty");
        }
        String logData = logs.get(0).getData();
        if (null == logData || "".equals(logData)) {
            throw new TransactionException("TransactionReceipt logs[0].data is empty");
        }
        RlpList rlp = RlpDecoder.decode((byte[])Numeric.hexStringToByteArray((String)logData));
        List rlpList = ((RlpList)rlp.getValues().get(0)).getValues();
        String decodedStatus = new String(((RlpString)rlpList.get(0)).getBytes());
        int statusCode = Integer.parseInt(decodedStatus);
        if (statusCode != 0) {
            throw new TransactionException("TransactionResponse code is 0");
        }
        ArrayList<Reward> rewards = new ArrayList<Reward>();
        ((RlpList)RlpDecoder.decode((byte[])((RlpString)rlpList.get(1)).getBytes()).getValues().get(0)).getValues().stream().forEach(rl -> {
            RlpList rlpL = (RlpList)rl;
            Reward reward = new Reward();
            reward.setNodeId(((RlpString)rlpL.getValues().get(0)).asString());
            reward.setStakingNum(((RlpString)rlpL.getValues().get(1)).asPositiveBigInteger());
            reward.setRewardBigIntegerValue(((RlpString)rlpL.getValues().get(2)).asPositiveBigInteger());
            rewards.add(reward);
        });
        return rewards;
    }

    public RemoteCall<CallResponse<List<Reward>>> getDelegateReward(String address, List<String> nodeList) {
        List bytesTypeList = nodeList.stream().map(nodeId -> new NodeId((String)nodeId)).collect(Collectors.toList());
        CustomStaticArray dynamicArray = new CustomStaticArray(bytesTypeList);
        Function function = new Function(5100, Arrays.asList(new BytesType(Bech32.addressDecode((String)address)), dynamicArray));
        return this.executeRemoteCallListValueReturn(function, Reward.class);
    }
}

