/*
 * Decompiled with CFR 0.152.
 */
package com.platon.contracts.ppos;

import com.platon.abi.solidity.datatypes.BytesType;
import com.platon.abi.solidity.datatypes.Utf8String;
import com.platon.abi.solidity.datatypes.generated.Uint32;
import com.platon.abi.solidity.datatypes.generated.Uint64;
import com.platon.contracts.ppos.BaseContract;
import com.platon.contracts.ppos.abi.Function;
import com.platon.contracts.ppos.dto.CallResponse;
import com.platon.contracts.ppos.dto.TransactionResponse;
import com.platon.contracts.ppos.dto.common.DuplicateSignType;
import com.platon.contracts.ppos.exception.EstimateGasException;
import com.platon.contracts.ppos.exception.NoSupportFunctionType;
import com.platon.crypto.Credentials;
import com.platon.parameters.NetworkParameters;
import com.platon.protocol.Web3j;
import com.platon.protocol.core.RemoteCall;
import com.platon.protocol.core.methods.response.PlatonSendTransaction;
import com.platon.tx.TransactionManager;
import com.platon.tx.gas.GasProvider;
import com.platon.utils.Numeric;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;

public class SlashContract
extends BaseContract {
    public static SlashContract load(Web3j web3j) {
        return new SlashContract(NetworkParameters.getPposContractAddressOfSlash(), web3j);
    }

    public static SlashContract load(Web3j web3j, TransactionManager transactionManager) {
        return new SlashContract(NetworkParameters.getPposContractAddressOfSlash(), web3j, transactionManager);
    }

    public static SlashContract load(Web3j web3j, Credentials credentials) {
        return new SlashContract(NetworkParameters.getPposContractAddressOfSlash(), web3j, credentials);
    }

    private SlashContract(String contractAddress, Web3j web3j) {
        super(contractAddress, web3j);
    }

    private SlashContract(String contractAddress, Web3j web3j, Credentials credentials) {
        super(contractAddress, web3j, credentials);
    }

    private SlashContract(String contractAddress, Web3j web3j, TransactionManager transactionManager) {
        super(contractAddress, web3j, transactionManager);
    }

    public RemoteCall<TransactionResponse> reportDoubleSign(DuplicateSignType duplicateSignType, String data) {
        Function function = this.createReportDoubleSignFunction(duplicateSignType, data);
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionResponse> reportDoubleSign(DuplicateSignType duplicateSignType, String data, GasProvider gasProvider) {
        Function function = this.createReportDoubleSignFunction(duplicateSignType, data);
        return this.executeRemoteCallTransaction(function, gasProvider);
    }

    public GasProvider getReportDoubleSignGasProvider(DuplicateSignType duplicateSignType, String data) throws IOException, EstimateGasException, NoSupportFunctionType {
        Function function = this.createReportDoubleSignFunction(duplicateSignType, data);
        return this.getDefaultGasProvider(function);
    }

    public RemoteCall<PlatonSendTransaction> reportDoubleSignReturnTransaction(DuplicateSignType duplicateSignType, String data) {
        Function function = this.createReportDoubleSignFunction(duplicateSignType, data);
        return this.executeRemoteCallTransactionStep1(function);
    }

    public RemoteCall<PlatonSendTransaction> reportDoubleSignReturnTransaction(DuplicateSignType duplicateSignType, String data, GasProvider gasProvider) {
        Function function = this.createReportDoubleSignFunction(duplicateSignType, data);
        return this.executeRemoteCallTransactionStep1(function, gasProvider);
    }

    private Function createReportDoubleSignFunction(DuplicateSignType duplicateSignType, String data) {
        Function function = new Function(3000, Arrays.asList(new Uint32(BigInteger.valueOf(duplicateSignType.getValue())), new Utf8String(data)));
        return function;
    }

    public RemoteCall<CallResponse<String>> checkDoubleSign(DuplicateSignType doubleSignType, String nodeId, BigInteger blockNumber) {
        Function function = new Function(3001, Arrays.asList(new Uint32((long)doubleSignType.getValue()), new BytesType(Numeric.hexStringToByteArray((String)nodeId)), new Uint64(blockNumber)));
        return this.executeRemoteCallObjectValueReturn(function, String.class);
    }
}

