/*
 * Decompiled with CFR 0.152.
 */
package com.platon.protocol;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.platon.protocol.core.Response;
import com.platon.protocol.deserializer.RawResponseDeserializer;

public class ObjectMapperFactory {
    private static final ObjectMapper DEFAULT_OBJECT_MAPPER = new ObjectMapper();

    public static ObjectMapper getObjectMapper() {
        return ObjectMapperFactory.getObjectMapper(false);
    }

    public static ObjectMapper getObjectMapper(boolean shouldIncludeRawResponses) {
        if (!shouldIncludeRawResponses) {
            return DEFAULT_OBJECT_MAPPER;
        }
        return ObjectMapperFactory.configureObjectMapper(new ObjectMapper(), true);
    }

    public static ObjectReader getObjectReader() {
        return DEFAULT_OBJECT_MAPPER.reader();
    }

    private static ObjectMapper configureObjectMapper(ObjectMapper objectMapper, boolean shouldIncludeRawResponses) {
        if (shouldIncludeRawResponses) {
            SimpleModule module = new SimpleModule();
            module.setDeserializerModifier(new BeanDeserializerModifier(){

                public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                    if (Response.class.isAssignableFrom(beanDesc.getBeanClass())) {
                        return new RawResponseDeserializer(deserializer);
                    }
                    return deserializer;
                }
            });
            objectMapper.registerModule((Module)module);
        }
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }

    static {
        ObjectMapperFactory.configureObjectMapper(DEFAULT_OBJECT_MAPPER, false);
    }
}

