/*
 * Decompiled with CFR 0.152.
 */
package com.platon.tx;

import com.platon.abi.solidity.EventEncoder;
import com.platon.abi.solidity.EventValues;
import com.platon.abi.solidity.FunctionEncoder;
import com.platon.abi.solidity.FunctionReturnDecoder;
import com.platon.abi.solidity.TypeReference;
import com.platon.abi.solidity.datatypes.Address;
import com.platon.abi.solidity.datatypes.Event;
import com.platon.abi.solidity.datatypes.Function;
import com.platon.abi.solidity.datatypes.Type;
import com.platon.crypto.Credentials;
import com.platon.protocol.Web3j;
import com.platon.protocol.core.DefaultBlockParameter;
import com.platon.protocol.core.DefaultBlockParameterName;
import com.platon.protocol.core.RemoteCall;
import com.platon.protocol.core.Response;
import com.platon.protocol.core.methods.request.Transaction;
import com.platon.protocol.core.methods.response.Log;
import com.platon.protocol.core.methods.response.PlatonCall;
import com.platon.protocol.core.methods.response.PlatonGetCode;
import com.platon.protocol.core.methods.response.TransactionReceipt;
import com.platon.protocol.exceptions.TransactionException;
import com.platon.tx.ManagedTransaction;
import com.platon.tx.RawTransactionManager;
import com.platon.tx.TransactionManager;
import com.platon.tx.exceptions.ContractCallException;
import com.platon.tx.exceptions.PlatonCallException;
import com.platon.tx.exceptions.PlatonCallTimeoutException;
import com.platon.tx.gas.GasProvider;
import com.platon.utils.Numeric;
import com.platon.utils.Strings;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class Contract
extends ManagedTransaction {
    public static final BigInteger GAS_LIMIT = BigInteger.valueOf(4300000L);
    public static final String FUNC_DEPLOY = "deploy";
    protected final String contractBinary;
    protected String contractAddress;
    protected GasProvider gasProvider;
    protected TransactionReceipt transactionReceipt;
    protected Map<String, String> deployedAddresses;
    protected DefaultBlockParameter defaultBlockParameter = DefaultBlockParameterName.LATEST;

    protected Contract(String contractBinary, String contractAddress, Web3j web3j, TransactionManager transactionManager, GasProvider gasProvider) {
        super(web3j, transactionManager);
        this.contractAddress = contractAddress;
        this.contractBinary = contractBinary;
        this.gasProvider = gasProvider;
    }

    protected Contract(String contractBinary, String contractAddress, Web3j web3j, Credentials credentials, GasProvider gasProvider) {
        this(contractBinary, contractAddress, web3j, new RawTransactionManager(web3j, credentials), gasProvider);
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public void setTransactionReceipt(TransactionReceipt transactionReceipt) {
        this.transactionReceipt = transactionReceipt;
    }

    public String getContractBinary() {
        return this.contractBinary;
    }

    public void setGasProvider(GasProvider gasProvider) {
        this.gasProvider = gasProvider;
    }

    public boolean isValid() throws IOException {
        if (this.contractAddress.equals("")) {
            throw new UnsupportedOperationException("Contract binary not present, you will need to regenerate your smart contract wrapper with web3j v2.2.0+");
        }
        PlatonGetCode ethGetCode = this.web3j.platonGetCode(this.contractAddress, DefaultBlockParameterName.LATEST).send();
        if (ethGetCode.hasError()) {
            return false;
        }
        String code = Numeric.cleanHexPrefix((String)ethGetCode.getCode());
        return !code.isEmpty() && this.contractBinary.contains(code);
    }

    public Optional<TransactionReceipt> getTransactionReceipt() {
        return Optional.ofNullable(this.transactionReceipt);
    }

    public void setDefaultBlockParameter(DefaultBlockParameter defaultBlockParameter) {
        this.defaultBlockParameter = defaultBlockParameter;
    }

    private List<Type> executeCall(Function function) throws IOException {
        String encodedFunction = FunctionEncoder.encode((Function)function);
        PlatonCall ethCall = this.web3j.platonCall(Transaction.createEthCallTransaction(this.transactionManager.getFromAddress(), this.contractAddress, encodedFunction), this.defaultBlockParameter).send();
        if (ethCall.hasError()) {
            String lowMessage;
            Response.Error error = ethCall.getError();
            String message = error.getMessage();
            String string = lowMessage = !Strings.isBlank((String)message) ? message.toLowerCase() : null;
            if (!Strings.isBlank((String)lowMessage) && lowMessage.contains("timeout")) {
                throw new PlatonCallTimeoutException(error.getCode(), error.getMessage(), ethCall);
            }
            throw new PlatonCallException(error.getCode(), error.getMessage(), ethCall);
        }
        String value = ethCall.getValue();
        return FunctionReturnDecoder.decode((String)value, (List)function.getOutputParameters());
    }

    protected <T extends Type> T executeCallSingleValueReturn(Function function) throws IOException {
        List<Type> values = this.executeCall(function);
        if (!values.isEmpty()) {
            return (T)values.get(0);
        }
        return null;
    }

    protected <T extends Type, R> R executeCallSingleValueReturn(Function function, Class<R> returnType) throws IOException {
        T result = this.executeCallSingleValueReturn(function);
        if (result == null) {
            throw new ContractCallException("Empty value (0x) returned from contract");
        }
        Object value = result.getValue();
        if (returnType.isAssignableFrom(value.getClass())) {
            return (R)value;
        }
        if (result.getClass().equals(Address.class) && returnType.equals(String.class)) {
            return (R)result.toString();
        }
        throw new ContractCallException("Unable to convert response: " + value + " to expected type: " + returnType.getSimpleName());
    }

    protected List<Type> executeCallMultipleValueReturn(Function function) throws IOException {
        return this.executeCall(function);
    }

    protected TransactionReceipt executeTransaction(Function function) throws IOException, TransactionException {
        return this.executeTransaction(function, BigInteger.ZERO);
    }

    private TransactionReceipt executeTransaction(Function function, BigInteger weiValue) throws IOException, TransactionException {
        return this.executeTransaction(FunctionEncoder.encode((Function)function), weiValue, function.getName());
    }

    TransactionReceipt executeTransaction(String data, BigInteger weiValue, String funcName) throws TransactionException, IOException {
        TransactionReceipt receipt = this.send(this.contractAddress, data, weiValue, this.gasProvider.getGasPrice(), this.gasProvider.getGasLimit());
        if (!receipt.isStatusOK()) {
            throw new TransactionException(String.format("Transaction has failed with status: %s. Gas used: %d. (not-enough gas?)", receipt.getStatus(), receipt.getGasUsed()));
        }
        return receipt;
    }

    protected <T extends Type> RemoteCall<T> executeRemoteCallSingleValueReturn(Function function) {
        return new RemoteCall<Type>(() -> this.executeCallSingleValueReturn(function));
    }

    protected <T> RemoteCall<T> executeRemoteCallSingleValueReturn(Function function, Class<T> returnType) {
        return new RemoteCall<Object>(() -> this.executeCallSingleValueReturn(function, returnType));
    }

    protected RemoteCall<List<Type>> executeRemoteCallMultipleValueReturn(Function function) {
        return new RemoteCall<List<Type>>(() -> this.executeCallMultipleValueReturn(function));
    }

    protected RemoteCall<TransactionReceipt> executeRemoteCallTransaction(Function function) {
        return new RemoteCall<TransactionReceipt>(() -> this.executeTransaction(function));
    }

    protected RemoteCall<TransactionReceipt> executeRemoteCallTransaction(Function function, BigInteger weiValue) {
        return new RemoteCall<TransactionReceipt>(() -> this.executeTransaction(function, weiValue));
    }

    private static <T extends Contract> T create(T contract, String binary, String encodedConstructor, BigInteger value) throws IOException, TransactionException {
        TransactionReceipt transactionReceipt = contract.executeTransaction(binary + encodedConstructor, value, FUNC_DEPLOY);
        String contractAddress = transactionReceipt.getContractAddress();
        if (contractAddress == null) {
            throw new RuntimeException("Empty contract address returned");
        }
        contract.setContractAddress(contractAddress);
        contract.setTransactionReceipt(transactionReceipt);
        return contract;
    }

    protected static <T extends Contract> T deploy(Class<T> type, Web3j web3j, Credentials credentials, GasProvider contractGasProvider, String binary, String encodedConstructor, BigInteger value) throws RuntimeException, TransactionException, IOException {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(String.class, Web3j.class, Credentials.class, GasProvider.class);
            constructor.setAccessible(true);
            Contract contract = (Contract)constructor.newInstance(null, web3j, credentials, contractGasProvider);
            return (T)Contract.create(contract, binary, encodedConstructor, value);
        }
        catch (TransactionException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static <T extends Contract> T deploy(Class<T> type, Web3j web3j, TransactionManager transactionManager, GasProvider contractGasProvider, String binary, String encodedConstructor, BigInteger value) throws RuntimeException, TransactionException, IOException {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(String.class, Web3j.class, TransactionManager.class, GasProvider.class);
            constructor.setAccessible(true);
            Contract contract = (Contract)constructor.newInstance(null, web3j, transactionManager, contractGasProvider);
            return (T)Contract.create(contract, binary, encodedConstructor, value);
        }
        catch (TransactionException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Contract> RemoteCall<T> deployRemoteCall(Class<T> type, Web3j web3j, Credentials credentials, GasProvider contractGasProvider, String binary, String encodedConstructor, BigInteger value) {
        return new RemoteCall<Contract>(() -> Contract.deploy(type, web3j, credentials, contractGasProvider, binary, encodedConstructor, value));
    }

    public static <T extends Contract> RemoteCall<T> deployRemoteCall(Class<T> type, Web3j web3j, Credentials credentials, GasProvider contractGasProvider, String binary, String encodedConstructor) {
        return new RemoteCall<Contract>(() -> Contract.deploy(type, web3j, credentials, contractGasProvider, binary, encodedConstructor, BigInteger.ZERO));
    }

    public static <T extends Contract> RemoteCall<T> deployRemoteCall(Class<T> type, Web3j web3j, TransactionManager transactionManager, GasProvider contractGasProvider, String binary, String encodedConstructor, BigInteger value) {
        return new RemoteCall<Contract>(() -> Contract.deploy(type, web3j, transactionManager, contractGasProvider, binary, encodedConstructor, value));
    }

    public static <T extends Contract> RemoteCall<T> deployRemoteCall(Class<T> type, Web3j web3j, TransactionManager transactionManager, GasProvider contractGasProvider, String binary, String encodedConstructor) {
        return new RemoteCall<Contract>(() -> Contract.deploy(type, web3j, transactionManager, contractGasProvider, binary, encodedConstructor, BigInteger.ZERO));
    }

    public static EventValues staticExtractEventParameters(Event event, Log log) {
        List<String> topics = log.getTopics();
        String encodedEventSignature = EventEncoder.encode((Event)event);
        if (topics == null || topics.size() == 0 || !topics.get(0).equals(encodedEventSignature)) {
            return null;
        }
        ArrayList<Type> indexedValues = new ArrayList<Type>();
        List nonIndexedValues = FunctionReturnDecoder.decode((String)log.getData(), (List)event.getNonIndexedParameters());
        List indexedParameters = event.getIndexedParameters();
        for (int i = 0; i < indexedParameters.size(); ++i) {
            Type value = FunctionReturnDecoder.decodeIndexedValue((String)topics.get(i + 1), (TypeReference)((TypeReference)indexedParameters.get(i)));
            indexedValues.add(value);
        }
        return new EventValues(indexedValues, nonIndexedValues);
    }

    protected EventValues extractEventParameters(Event event, Log log) {
        return Contract.staticExtractEventParameters(event, log);
    }

    protected List<EventValues> extractEventParameters(Event event, TransactionReceipt transactionReceipt) {
        return transactionReceipt.getLogs().stream().map(log -> this.extractEventParameters(event, (Log)log)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected EventValuesWithLog extractEventParametersWithLog(Event event, Log log) {
        EventValues eventValues = Contract.staticExtractEventParameters(event, log);
        return eventValues == null ? null : new EventValuesWithLog(eventValues, log);
    }

    protected List<EventValuesWithLog> extractEventParametersWithLog(Event event, TransactionReceipt transactionReceipt) {
        return transactionReceipt.getLogs().stream().map(log -> this.extractEventParametersWithLog(event, (Log)log)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected String getStaticDeployedAddress(String networkId) {
        return null;
    }

    public final void setDeployedAddress(String networkId, String address) {
        if (this.deployedAddresses == null) {
            this.deployedAddresses = new HashMap<String, String>();
        }
        this.deployedAddresses.put(networkId, address);
    }

    public final String getDeployedAddress(String networkId) {
        String addr = null;
        if (this.deployedAddresses != null) {
            addr = this.deployedAddresses.get(networkId);
        }
        return addr == null ? this.getStaticDeployedAddress(networkId) : addr;
    }

    protected static <S extends Type, T> List<T> convertToNative(List<S> arr) {
        ArrayList<Object> out = new ArrayList<Object>();
        Iterator<S> it = arr.iterator();
        while (it.hasNext()) {
            out.add(((Type)it.next()).getValue());
        }
        return out;
    }

    public static class EventValuesWithLog {
        private final EventValues eventValues;
        private final Log log;

        private EventValuesWithLog(EventValues eventValues, Log log) {
            this.eventValues = eventValues;
            this.log = log;
        }

        public List<Type> getIndexedValues() {
            return this.eventValues.getIndexedValues();
        }

        public List<Type> getNonIndexedValues() {
            return this.eventValues.getNonIndexedValues();
        }

        public Log getLog() {
            return this.log;
        }
    }
}

