/*
 * Decompiled with CFR 0.152.
 */
package com.platon.tx;

import com.platon.crypto.Credentials;
import com.platon.protocol.Web3j;
import com.platon.protocol.core.RemoteCall;
import com.platon.protocol.core.methods.response.TransactionReceipt;
import com.platon.protocol.exceptions.TransactionException;
import com.platon.tx.ManagedTransaction;
import com.platon.tx.RawTransactionManager;
import com.platon.tx.TransactionManager;
import com.platon.utils.Convert;
import com.platon.utils.Numeric;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Transfer
extends ManagedTransaction {
    public static final BigInteger GAS_LIMIT = BigInteger.valueOf(21000L);

    public Transfer(Web3j web3j, TransactionManager transactionManager) {
        super(web3j, transactionManager);
    }

    private TransactionReceipt send(String toAddress, BigDecimal value, Convert.Unit unit) throws IOException, InterruptedException, TransactionException {
        BigInteger gasPrice = this.requestCurrentGasPrice();
        return this.send(toAddress, value, unit, gasPrice, GAS_LIMIT);
    }

    private TransactionReceipt send(String toAddress, BigDecimal value, Convert.Unit unit, BigInteger gasPrice, BigInteger gasLimit) throws IOException, InterruptedException, TransactionException {
        BigDecimal vonValue = Convert.toVon((BigDecimal)value, (Convert.Unit)unit);
        if (!Numeric.isIntegerValue((BigDecimal)vonValue)) {
            throw new UnsupportedOperationException("Non decimal Von value provided: " + value + " " + unit.toString() + " = " + vonValue + " Von");
        }
        return this.send(toAddress, "", vonValue.toBigIntegerExact(), gasPrice, gasLimit);
    }

    public static RemoteCall<TransactionReceipt> sendFunds(Web3j web3j, Credentials credentials, String toAddress, BigDecimal value, Convert.Unit unit) throws InterruptedException, IOException, TransactionException {
        RawTransactionManager transactionManager = new RawTransactionManager(web3j, credentials);
        return new RemoteCall<TransactionReceipt>(() -> new Transfer(web3j, transactionManager).send(toAddress, value, unit));
    }

    public RemoteCall<TransactionReceipt> sendFunds(String toAddress, BigDecimal value, Convert.Unit unit) {
        return new RemoteCall<TransactionReceipt>(() -> this.send(toAddress, value, unit));
    }

    public RemoteCall<TransactionReceipt> sendFunds(String toAddress, BigDecimal value, Convert.Unit unit, BigInteger gasPrice, BigInteger gasLimit) {
        return new RemoteCall<TransactionReceipt>(() -> this.send(toAddress, value, unit, gasPrice, gasLimit));
    }
}

