/*
 * Decompiled with CFR 0.152.
 */
package com.platon.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class Async {
    private static final ExecutorService executor = Executors.newCachedThreadPool();

    public static <T> CompletableFuture<T> run(Callable<T> callable) {
        CompletableFuture result = new CompletableFuture();
        CompletableFuture.runAsync(() -> {
            try {
                result.complete(callable.call());
            }
            catch (Throwable e) {
                result.completeExceptionally(e);
            }
        }, executor);
        return result;
    }

    private static int getCpuCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static ScheduledExecutorService defaultExecutorService() {
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(Async.getCpuCount());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> Async.shutdown(scheduledExecutorService)));
        return scheduledExecutorService;
    }

    private static void shutdown(ExecutorService executorService) {
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                executorService.shutdownNow();
                if (!executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    System.err.println("Thread pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> Async.shutdown(executor)));
    }
}

