/*
 * Decompiled with CFR 0.152.
 */
package com.platon.crypto;

import com.platon.crypto.Credentials;
import com.platon.crypto.ECKeyPair;
import com.platon.crypto.SampleKeys;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class CredentialsTest {
    @Test
    public void testCredentialsFromString() {
        Credentials credentials = Credentials.create((ECKeyPair)SampleKeys.KEY_PAIR);
        this.verify(credentials);
    }

    @Test
    public void testCredentialsFromECKeyPair() {
        Credentials credentials = Credentials.create((String)"a392604efc2fad9c0b3da43b5f698a2e3f270f170d859912be0d54742275c5f6", (String)"0x506bc1dc099358e5137292f4efdd57e400f29ba5132aa5d12b18dac1c1f6aaba645c0b7b58158babbfa6c6cd5a48aa7340a8749176b120e8516216787a13dc76");
        this.verify(credentials);
    }

    private void verify(Credentials credentials) {
        Assert.assertEquals((Object)credentials.getAddress(), (Object)SampleKeys.BECH32_ADDRESS);
        Assert.assertThat((Object)credentials.getEcKeyPair(), (Matcher)Is.is((Object)SampleKeys.KEY_PAIR));
    }
}

