/*
 * Decompiled with CFR 0.152.
 */
package com.platon.crypto;

import com.platon.crypto.ECKeyPair;
import com.platon.crypto.Keys;
import com.platon.crypto.SampleKeys;
import com.platon.utils.Numeric;
import com.platon.utils.Strings;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class KeysTest {
    private static final byte[] ENCODED;

    @Test
    public void testCreateSecp256k1KeyPair() throws Exception {
        KeyPair keyPair = Keys.createSecp256k1KeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        Assert.assertNotNull((Object)privateKey);
        Assert.assertNotNull((Object)publicKey);
        Assert.assertThat((Object)privateKey.getEncoded().length, (Matcher)CoreMatchers.is((Object)144));
        Assert.assertThat((Object)publicKey.getEncoded().length, (Matcher)CoreMatchers.is((Object)88));
    }

    @Test
    public void testCreateEcKeyPair() throws Exception {
        ECKeyPair ecKeyPair = Keys.createEcKeyPair();
        Assert.assertThat((Object)ecKeyPair.getPublicKey().signum(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)ecKeyPair.getPrivateKey().signum(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testGetAddressString() {
        Assert.assertThat((Object)Keys.getAddress((String)"0x506bc1dc099358e5137292f4efdd57e400f29ba5132aa5d12b18dac1c1f6aaba645c0b7b58158babbfa6c6cd5a48aa7340a8749176b120e8516216787a13dc76"), (Matcher)CoreMatchers.is((Object)SampleKeys.HEX_ADDRESS_NO_PREFIX));
    }

    @Test
    public void testGetAddressZeroPaddedAddress() {
        String publicKey = "0xa1b31be4d58a7ddd24b135db0da56a90fb5382077ae26b250e1dc9cd6232ce2270f4c995428bc76aa78e522316e95d7834d725efc9ca754d043233af6ca90113";
        Assert.assertThat((Object)Keys.getAddress((String)publicKey), (Matcher)CoreMatchers.is((Object)"01c52b08330e05d731e38c856c1043288f7d9744"));
    }

    @Test
    public void testGetAddressBigInteger() {
        Assert.assertThat((Object)Keys.getAddress((BigInteger)SampleKeys.PUBLIC_KEY), (Matcher)CoreMatchers.is((Object)SampleKeys.HEX_ADDRESS_NO_PREFIX));
    }

    @Test
    public void testGetAddressSmallPublicKey() {
        byte[] address = Keys.getAddress((byte[])Numeric.toBytesPadded((BigInteger)BigInteger.valueOf(4660L), (int)64));
        String expected = Numeric.toHexStringNoPrefix((byte[])address);
        Assert.assertThat((Object)Keys.getAddress((String)"0x1234"), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    @Test
    public void testGetAddressZeroPadded() {
        byte[] address = Keys.getAddress((byte[])Numeric.toBytesPadded((BigInteger)BigInteger.valueOf(4660L), (int)64));
        String expected = Numeric.toHexStringNoPrefix((byte[])address);
        String value = "1234";
        Assert.assertThat((Object)Keys.getAddress((String)("0x" + Strings.zeros((int)(128 - value.length())) + value)), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    @Test
    public void testToChecksumAddress() {
        Assert.assertThat((Object)Keys.toChecksumAddress((String)"0xfb6916095ca1df60bb79ce92ce3ea74c37c5d359"), (Matcher)CoreMatchers.is((Object)"0xfB6916095ca1df60bB79Ce92cE3Ea74c37c5d359"));
        Assert.assertThat((Object)Keys.toChecksumAddress((String)"0x52908400098527886E0F7030069857D2E4169EE7"), (Matcher)CoreMatchers.is((Object)"0x52908400098527886E0F7030069857D2E4169EE7"));
        Assert.assertThat((Object)Keys.toChecksumAddress((String)"0x8617E340B3D01FA5F11F306F4090FD50E238070D"), (Matcher)CoreMatchers.is((Object)"0x8617E340B3D01FA5F11F306F4090FD50E238070D"));
        Assert.assertThat((Object)Keys.toChecksumAddress((String)"0xde709f2102306220921060314715629080e2fb77"), (Matcher)CoreMatchers.is((Object)"0xde709f2102306220921060314715629080e2fb77"));
        Assert.assertThat((Object)Keys.toChecksumAddress((String)"0x27b1fdb04752bbc536007a920d24acb045561c26"), (Matcher)CoreMatchers.is((Object)"0x27b1fdb04752bbc536007a920d24acb045561c26"));
        Assert.assertThat((Object)Keys.toChecksumAddress((String)"0x5aAeb6053F3E94C9b9A09f33669435E7Ef1BeAed"), (Matcher)CoreMatchers.is((Object)"0x5aAeb6053F3E94C9b9A09f33669435E7Ef1BeAed"));
        Assert.assertThat((Object)Keys.toChecksumAddress((String)"0xfB6916095ca1df60bB79Ce92cE3Ea74c37c5d359"), (Matcher)CoreMatchers.is((Object)"0xfB6916095ca1df60bB79Ce92cE3Ea74c37c5d359"));
        Assert.assertThat((Object)Keys.toChecksumAddress((String)"0xdbF03B407c01E7cD3CBea99509d93f8DDDC8C6FB"), (Matcher)CoreMatchers.is((Object)"0xdbF03B407c01E7cD3CBea99509d93f8DDDC8C6FB"));
        Assert.assertThat((Object)Keys.toChecksumAddress((String)"0xD1220A0cf47c7B9Be7A2E6BA89F429762e7b9aDb"), (Matcher)CoreMatchers.is((Object)"0xD1220A0cf47c7B9Be7A2E6BA89F429762e7b9aDb"));
    }

    @Test
    public void testSerializeECKey() {
        Assert.assertThat((Object)Keys.serialize((ECKeyPair)SampleKeys.KEY_PAIR), (Matcher)CoreMatchers.is((Object)ENCODED));
    }

    @Test
    public void testDeserializeECKey() {
        Assert.assertThat((Object)Keys.deserialize((byte[])ENCODED), (Matcher)CoreMatchers.is((Object)SampleKeys.KEY_PAIR));
    }

    @Test(expected=RuntimeException.class)
    public void testDeserializeInvalidKey() {
        Keys.deserialize((byte[])new byte[0]);
    }

    static {
        byte[] privateKey = Numeric.hexStringToByteArray((String)"a392604efc2fad9c0b3da43b5f698a2e3f270f170d859912be0d54742275c5f6");
        byte[] publicKey = Numeric.hexStringToByteArray((String)"0x506bc1dc099358e5137292f4efdd57e400f29ba5132aa5d12b18dac1c1f6aaba645c0b7b58158babbfa6c6cd5a48aa7340a8749176b120e8516216787a13dc76");
        ENCODED = Arrays.copyOf(privateKey, privateKey.length + publicKey.length);
        System.arraycopy(publicKey, 0, ENCODED, privateKey.length, publicKey.length);
    }
}

