/*
 * Decompiled with CFR 0.152.
 */
package com.platon.crypto;

import com.platon.crypto.ECDSASignature;
import com.platon.crypto.Hash;
import com.platon.crypto.Keys;
import com.platon.crypto.Sign;
import com.platon.utils.Numeric;
import java.math.BigInteger;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ECRecoverTest {
    public static final String PERSONAL_MESSAGE_PREFIX = "\u0019Ethereum Signed Message:\n";

    @Test
    public void testRecoverAddressFromSignature() {
        String signature = "0x2c6401216c9031b9a6fb8cbfccab4fcec6c951cdf40e2320108d1856eb532250576865fbcd452bcdc4c57321b619ed7a9cfd38bd973c3e1e0243ac2777fe9d5b1b";
        String address = "0x31b26e43651e9371c88af3d36c14cfd938baf4fd";
        String message = "v0G9u7huK4mJb2K1";
        String prefix = PERSONAL_MESSAGE_PREFIX + message.length();
        byte[] msgHash = Hash.sha3((byte[])(prefix + message).getBytes());
        byte[] signatureBytes = Numeric.hexStringToByteArray((String)signature);
        byte v = signatureBytes[64];
        if (v < 27) {
            v = (byte)(v + 27);
        }
        Sign.SignatureData sd = new Sign.SignatureData(v, Arrays.copyOfRange(signatureBytes, 0, 32), Arrays.copyOfRange(signatureBytes, 32, 64));
        String addressRecovered = null;
        boolean match = false;
        for (int i = 0; i < 4; ++i) {
            BigInteger publicKey = Sign.recoverFromSignature((int)((byte)i), (ECDSASignature)new ECDSASignature(new BigInteger(1, sd.getR()), new BigInteger(1, sd.getS())), (byte[])msgHash);
            if (publicKey == null || !(addressRecovered = "0x" + Keys.getAddress((BigInteger)publicKey)).equals(address)) continue;
            match = true;
            break;
        }
        Assert.assertThat(addressRecovered, (Matcher)CoreMatchers.is((Object)address));
        Assert.assertTrue((boolean)match);
    }
}

