/*
 * Decompiled with CFR 0.152.
 */
package com.platon.crypto;

import com.platon.crypto.Credentials;
import com.platon.crypto.RawTransaction;
import com.platon.crypto.Sign;
import com.platon.crypto.TransactionEncoder;
import com.platon.parameters.NetworkParameters;
import com.platon.rlp.solidity.RlpString;
import com.platon.utils.Numeric;
import java.math.BigInteger;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;

public class TransactionEncoderTest {
    @Test
    public void testEtherTransactionAsRlpValues() {
        List rlpStrings = TransactionEncoder.asRlpValues((RawTransaction)TransactionEncoderTest.createEtherTransaction(), (Sign.SignatureData)new Sign.SignatureData(0, new byte[32], new byte[32]));
        Assert.assertThat((Object)rlpStrings.size(), (Matcher)CoreMatchers.is((Object)9));
        Assert.assertThat(rlpStrings.get(3), (Matcher)IsEqual.equalTo((Object)RlpString.create((BigInteger)new BigInteger("33c98f20dd73d7bb1d533c4aa3371f2b30c6ebde", 16))));
    }

    @Test
    public void testContractAsRlpValues() {
        List rlpStrings = TransactionEncoder.asRlpValues((RawTransaction)TransactionEncoderTest.createContractTransaction(), null);
        Assert.assertThat((Object)rlpStrings.size(), (Matcher)CoreMatchers.is((Object)6));
        Assert.assertThat(rlpStrings.get(3), (Matcher)CoreMatchers.is((Object)RlpString.create((String)"")));
    }

    @Test
    public void testEip155Encode() {
        Assert.assertThat((Object)TransactionEncoder.encode((RawTransaction)TransactionEncoderTest.createEip155RawTransaction(), (long)NetworkParameters.getChainId()), (Matcher)CoreMatchers.is((Object)Numeric.hexStringToByteArray((String)"0xef098504a817c8008252089433c98f20dd73d7bb1d533c4aa3371f2b30c6ebde880de0b6b3a7640000808303113a8080")));
    }

    @Test
    public void testEip155Transaction() {
        Credentials credentials = Credentials.create((String)"0x4646464646464646464646464646464646464646464646464646464646464646");
        Assert.assertThat((Object)TransactionEncoder.signMessage((RawTransaction)TransactionEncoderTest.createEip155RawTransaction(), (long)NetworkParameters.getChainId(), (Credentials)credentials), (Matcher)CoreMatchers.is((Object)Numeric.hexStringToByteArray((String)"0xf86f098504a817c8008252089433c98f20dd73d7bb1d533c4aa3371f2b30c6ebde880de0b6b3a76400008083062297a0045a8bbf804cc2c6a59f5f6acb544bc60efee31648581d00ebe58dfad67bb10aa01653665e957167922c95385d64590c1c56c7d225ef2ee214add692103a659514")));
    }

    private static RawTransaction createEtherTransaction() {
        return RawTransaction.createEtherTransaction((BigInteger)BigInteger.ZERO, (BigInteger)BigInteger.ONE, (BigInteger)BigInteger.TEN, (String)"atp1x0yc7gxaw0tmk82n8392xdcl9vcvd677g57j0q", (BigInteger)BigInteger.valueOf(Long.MAX_VALUE));
    }

    static RawTransaction createContractTransaction() {
        return RawTransaction.createContractTransaction((BigInteger)BigInteger.ZERO, (BigInteger)BigInteger.ONE, (BigInteger)BigInteger.TEN, (BigInteger)BigInteger.valueOf(Long.MAX_VALUE), (String)"01234566789");
    }

    private static RawTransaction createEip155RawTransaction() {
        return RawTransaction.createEtherTransaction((BigInteger)BigInteger.valueOf(9L), (BigInteger)BigInteger.valueOf(20000000000L), (BigInteger)BigInteger.valueOf(21000L), (String)"atp1x0yc7gxaw0tmk82n8392xdcl9vcvd677g57j0q", (BigInteger)BigInteger.valueOf(1000000000000000000L));
    }
}

