/*
 * Decompiled with CFR 0.152.
 */
package com.platon.crypto;

import com.platon.bech32.Bech32;
import com.platon.crypto.Credentials;
import com.platon.crypto.RawTransaction;
import com.platon.crypto.SampleKeys;
import com.platon.crypto.SignedRawTransaction;
import com.platon.crypto.TransactionDecoder;
import com.platon.crypto.TransactionEncoder;
import com.platon.parameters.NetworkParameters;
import com.platon.utils.Numeric;
import java.math.BigInteger;
import org.junit.Assert;
import org.junit.Test;

public class TransactionDecoderTest {
    @Test
    public void testDecoding() throws Exception {
        BigInteger nonce = BigInteger.ZERO;
        BigInteger gasPrice = BigInteger.ONE;
        BigInteger gasLimit = BigInteger.TEN;
        String to = "atp1x0yc7gxaw0tmk82n8392xdcl9vcvd677g57j0q";
        BigInteger value = BigInteger.valueOf(Long.MAX_VALUE);
        RawTransaction rawTransaction = RawTransaction.createEtherTransaction((BigInteger)nonce, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)to, (BigInteger)value);
        byte[] encodedMessage = TransactionEncoder.encode((RawTransaction)rawTransaction);
        String hexMessage = Numeric.toHexString((byte[])encodedMessage);
        RawTransaction result = TransactionDecoder.decode((String)hexMessage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)nonce, (Object)result.getNonce());
        Assert.assertEquals((Object)gasPrice, (Object)result.getGasPrice());
        Assert.assertEquals((Object)gasLimit, (Object)result.getGasLimit());
        Assert.assertEquals((Object)to, (Object)Bech32.addressEncode((String)NetworkParameters.getHrp(), (String)result.getTo()));
        Assert.assertEquals((Object)value, (Object)result.getValue());
        Assert.assertEquals((Object)"", (Object)result.getData());
    }

    @Test
    public void testDecodingSignedChainId() throws Exception {
        BigInteger nonce = BigInteger.ZERO;
        BigInteger gasPrice = BigInteger.ONE;
        BigInteger gasLimit = BigInteger.TEN;
        String to = "atp1x0yc7gxaw0tmk82n8392xdcl9vcvd677g57j0q";
        BigInteger value = BigInteger.valueOf(Long.MAX_VALUE);
        RawTransaction rawTransaction = RawTransaction.createEtherTransaction((BigInteger)nonce, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)to, (BigInteger)value);
        byte[] signedMessage = TransactionEncoder.signMessage((RawTransaction)rawTransaction, (long)NetworkParameters.getChainId(), (Credentials)SampleKeys.CREDENTIALS);
        String hexMessage = Numeric.toHexString((byte[])signedMessage);
        RawTransaction result = TransactionDecoder.decode((String)hexMessage);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)nonce, (Object)result.getNonce());
        Assert.assertEquals((Object)gasPrice, (Object)result.getGasPrice());
        Assert.assertEquals((Object)gasLimit, (Object)result.getGasLimit());
        Assert.assertEquals((Object)to, (Object)result.getTo());
        Assert.assertEquals((Object)value, (Object)result.getValue());
        Assert.assertEquals((Object)"", (Object)result.getData());
        Assert.assertTrue((boolean)(result instanceof SignedRawTransaction));
        SignedRawTransaction signedResult = (SignedRawTransaction)result;
        Assert.assertEquals((Object)SampleKeys.BECH32_ADDRESS, (Object)signedResult.getFrom());
        signedResult.verify(SampleKeys.BECH32_ADDRESS);
        Assert.assertEquals((long)NetworkParameters.getChainId(), (long)signedResult.getChainId());
    }

    @Test
    public void testRSize31() throws Exception {
        String hexTransaction = "0xf885370183419ce09433c98f20dd73d7bb1d533c4aa3371f2b30c6ebde80a45093dc7d000000000000000000000000000000000000000000000000000000000000003581eba08b3d958db92dec4a69402f285ad2654b9d6b50e2b5bd751fad02bc9820248233a07cbf75551af26b9d73b27ae94099fd45378d50cb5d94ca73644427a20f0638fb";
        RawTransaction result = TransactionDecoder.decode((String)hexTransaction);
        SignedRawTransaction signedResult = (SignedRawTransaction)result;
        Assert.assertEquals((Object)SampleKeys.BECH32_ADDRESS, (Object)signedResult.getFrom());
    }
}

