/*
 * Decompiled with CFR 0.152.
 */
package com.platon.crypto;

import com.platon.bech32.Bech32;
import com.platon.crypto.ECKeyPair;
import com.platon.crypto.Keys;
import com.platon.parameters.NetworkParameters;
import com.platon.utils.Numeric;
import java.util.Objects;
import org.bouncycastle.util.encoders.Hex;

public class Credentials {
    private final ECKeyPair ecKeyPair;
    private final String address;

    private Credentials(ECKeyPair ecKeyPair, String address) {
        this.ecKeyPair = ecKeyPair;
        this.address = address;
    }

    public ECKeyPair getEcKeyPair() {
        return this.ecKeyPair;
    }

    public String getAddress(NetworkParameters networkParameters) {
        byte[] originBytes = Bech32.addressDecode((String)this.address);
        return Bech32.addressEncode((String)networkParameters.getHrp(), (String)Hex.toHexString((byte[])originBytes));
    }

    public String getAddress() {
        return this.address;
    }

    public static Credentials create(ECKeyPair ecKeyPair) {
        String hexAddress = Numeric.prependHexPrefix((String)Keys.getAddress(ecKeyPair));
        String address = Bech32.addressEncode((String)NetworkParameters.getHrp(), (String)hexAddress);
        return new Credentials(ecKeyPair, address);
    }

    public static Credentials create(String privateKey, String publicKey) {
        return Credentials.create(new ECKeyPair(Numeric.toBigInt((String)privateKey), Numeric.toBigInt((String)publicKey)));
    }

    public static Credentials create(String privateKey) {
        return Credentials.create(ECKeyPair.create(Numeric.toBigInt((String)privateKey)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Credentials that = (Credentials)o;
        return Objects.equals(this.ecKeyPair, that.ecKeyPair) && Objects.equals(this.address, that.address);
    }

    public int hashCode() {
        return Objects.hash(this.ecKeyPair, this.address);
    }
}

