/*
 * Decompiled with CFR 0.152.
 */
package com.platon.crypto;

import com.platon.crypto.Base58;
import com.platon.crypto.Bip32ECKeyPair;
import com.platon.crypto.Bip32Test;
import com.platon.crypto.Bip39Wallet;
import com.platon.crypto.Bip44WalletUtils;
import com.platon.crypto.Credentials;
import com.platon.crypto.ECKeyPair;
import com.platon.crypto.MnemonicUtils;
import com.platon.crypto.WalletUtilsTest;
import com.platon.parameters.NetworkParameters;
import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Bip44WalletUtilsTest {
    private File tempDir;

    @Before
    public void setUp() throws Exception {
        this.tempDir = WalletUtilsTest.createTempDir();
    }

    @After
    public void tearDown() throws Exception {
        for (File file : this.tempDir.listFiles()) {
            file.delete();
        }
        this.tempDir.delete();
    }

    @Test
    public void generateBip44KeyPair() {
        String mnemonic = "spider elbow fossil truck deal circle divert sleep safe report laundry above";
        byte[] seed = MnemonicUtils.generateSeed((String)mnemonic, null);
        String seedStr = this.bytesToHex(seed);
        Assert.assertEquals((Object)"f0d2ab78b96acd147119abad1cd70eb4fec4f0e0a95744cf532e6a09347b08101213b4cbf50eada0eb89cba444525fe28e69707e52aa301c6b47ce1c5ef82eb5", (Object)seedStr);
        Bip32ECKeyPair masterKeypair = Bip32ECKeyPair.generateKeyPair((byte[])seed);
        Assert.assertEquals((Object)"xprv9s21ZrQH143K2yA9Cdad5gjqHRC7apVUgEyYq5jXeXigDZ3PfEnps44tJprtMXr7PZivEsin6Qrbad7PuiEy4tn5jAEK6A3U46f9KvfRCmD", (Object)Base58.encode((byte[])Bip32Test.addChecksum(Bip32Test.serializePrivate(masterKeypair))));
        Bip32ECKeyPair bip44Keypair = Bip44WalletUtils.generateBip44KeyPair((Bip32ECKeyPair)masterKeypair);
        Assert.assertEquals((Object)"xprvA21iQhYkgksD4fXqSAvbJxqhzcULByCqRPLciwEBstGYTTEbEhUJp4cn3foK7xbMiGMfhFKvKmauQ5SjoqvkTE7XKFqHaa6F8XBx78N9CRh", (Object)Base58.encode((byte[])Bip32Test.addChecksum(Bip32Test.serializePrivate(bip44Keypair))));
        Assert.assertEquals((Object)"xpub6F14pD5eX8RWH9cJYCTbg6nSYeJpbRvgncGDXKdoSDoXLFZjnEnZMrwFtv8TTxJ3s4e9oxDFcfQXSRyuzbaovNmKFJogGp3vGH7EwUCncei", (Object)Base58.encode((byte[])Bip32Test.addChecksum(Bip32Test.serializePublic(bip44Keypair))));
    }

    @Test
    public void deriveChildKey() {
        NetworkParameters.selectPlatON();
        String mnemonic = "spider elbow fossil truck deal circle divert sleep safe report laundry above";
        byte[] seed = MnemonicUtils.generateSeed((String)mnemonic, null);
        Bip32ECKeyPair masterKeypair = Bip32ECKeyPair.generateKeyPair((byte[])seed);
        Bip32ECKeyPair bip44Keypair = Bip44WalletUtils.generateBip44KeyPair((Bip32ECKeyPair)masterKeypair);
        for (int i = 0; i < 1; ++i) {
            Bip32ECKeyPair bip32ECKeyPair = bip44Keypair.deriveChildKey(i);
            String address = Credentials.create((ECKeyPair)bip32ECKeyPair).getAddress();
            Assert.assertEquals((Object)"lat134h3492x5lfrukdweagu7d77udn5xeje54hdck", (Object)address);
        }
    }

    @Test
    public void generateBip44KeyPairTestNet() {
        String mnemonic = "spider elbow fossil truck deal circle divert sleep safe report laundry above";
        byte[] seed = MnemonicUtils.generateSeed((String)mnemonic, null);
        String seedStr = this.bytesToHex(seed);
        Assert.assertEquals((Object)"f0d2ab78b96acd147119abad1cd70eb4fec4f0e0a95744cf532e6a09347b08101213b4cbf50eada0eb89cba444525fe28e69707e52aa301c6b47ce1c5ef82eb5", (Object)seedStr);
        Bip32ECKeyPair masterKeypair = Bip32ECKeyPair.generateKeyPair((byte[])seed);
        Assert.assertEquals((Object)"xprv9s21ZrQH143K2yA9Cdad5gjqHRC7apVUgEyYq5jXeXigDZ3PfEnps44tJprtMXr7PZivEsin6Qrbad7PuiEy4tn5jAEK6A3U46f9KvfRCmD", (Object)Base58.encode((byte[])Bip32Test.addChecksum(Bip32Test.serializePrivate(masterKeypair))));
        Bip32ECKeyPair bip44Keypair = Bip44WalletUtils.generateBip44KeyPair((Bip32ECKeyPair)masterKeypair, (boolean)true);
        Assert.assertEquals((Object)"xprv9zhLxq63By3SX5hAMKnxjGy7L18bnn7GzDQv53eYYqeRX9M82riC1dqovamttwFpk2ZkDQxgcikBQzs1DTu2KShJJqnqgx83EftUB3k39uc", (Object)Base58.encode((byte[])Bip32Test.addChecksum(Bip32Test.serializePrivate(bip44Keypair))));
        Assert.assertEquals((Object)"xpub6DghNLcw2LbjjZmdTMKy6Quqt2y6CEq8MSLWsS4A7BBQPwgGaQ2SZSAHmsrqBVxLegjW2mBfcvDBhpeEqCmucTTPJiNLHQkiDuKwHs9gEtk", (Object)Base58.encode((byte[])Bip32Test.addChecksum(Bip32Test.serializePublic(bip44Keypair))));
    }

    @Test
    public void testGenerateBip44Wallets() throws Exception {
        Bip39Wallet wallet = Bip44WalletUtils.generateBip44Wallet((String)"123456", (File)this.tempDir);
        byte[] seed = MnemonicUtils.generateSeed((String)wallet.getMnemonic(), (String)"123456");
        Bip32ECKeyPair masterKeypair = Bip32ECKeyPair.generateKeyPair((byte[])seed);
        Bip32ECKeyPair bip44Keypair = Bip44WalletUtils.generateBip44KeyPair((Bip32ECKeyPair)masterKeypair);
        Credentials credentials = Credentials.create((ECKeyPair)bip44Keypair);
        Assert.assertEquals((Object)credentials, (Object)Bip44WalletUtils.loadBip44Credentials((String)"123456", (String)wallet.getMnemonic()));
    }

    private String bytesToHex(byte[] bytes) {
        char[] HEX_CHARS = "0123456789abcdef".toCharArray();
        char[] chars = new char[2 * bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            chars[2 * i] = HEX_CHARS[(bytes[i] & 0xF0) >>> 4];
            chars[2 * i + 1] = HEX_CHARS[bytes[i] & 0xF];
        }
        return new String(chars);
    }
}

