/*
 * Decompiled with CFR 0.152.
 */
package com.platon.crypto;

import com.platon.crypto.ECKeyPair;
import com.platon.crypto.SampleKeys;
import com.platon.crypto.Sign;
import com.platon.utils.Numeric;
import java.math.BigInteger;
import java.security.SignatureException;
import org.bouncycastle.math.ec.ECPoint;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class SignTest {
    private static final byte[] TEST_MESSAGE = "A test message".getBytes();

    @Test
    @Ignore
    public void testSignMessage() {
        Sign.SignatureData signatureData = Sign.signMessage((byte[])TEST_MESSAGE, (ECKeyPair)SampleKeys.KEY_PAIR);
        Sign.SignatureData expected = new Sign.SignatureData(27, Numeric.hexStringToByteArray((String)"0x9631f6d21dec448a213585a4a41a28ef3d4337548aa34734478b563036163786"), Numeric.hexStringToByteArray((String)"0x2ff816ee6bbb82719e983ecd8a33a4b45d32a4b58377ef1381163d75eedc900b"));
        Assert.assertThat((Object)signatureData, (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test
    public void testSignedMessageToKey() throws SignatureException {
        Sign.SignatureData signatureData = Sign.signMessage((byte[])TEST_MESSAGE, (ECKeyPair)SampleKeys.KEY_PAIR);
        BigInteger key = Sign.signedMessageToKey((byte[])TEST_MESSAGE, (Sign.SignatureData)signatureData);
        Assert.assertThat((Object)key, (Matcher)IsEqual.equalTo((Object)SampleKeys.PUBLIC_KEY));
    }

    @Test
    public void testPublicKeyFromPrivateKey() {
        Assert.assertThat((Object)Sign.publicKeyFromPrivate((BigInteger)SampleKeys.PRIVATE_KEY), (Matcher)IsEqual.equalTo((Object)SampleKeys.PUBLIC_KEY));
    }

    @Test(expected=RuntimeException.class)
    public void testInvalidSignature() throws SignatureException {
        Sign.signedMessageToKey((byte[])TEST_MESSAGE, (Sign.SignatureData)new Sign.SignatureData(27, new byte[]{1}, new byte[]{0}));
    }

    @Test
    public void testPublicKeyFromPrivatePoint() {
        ECPoint point = Sign.publicPointFromPrivate((BigInteger)SampleKeys.PRIVATE_KEY);
        Assert.assertThat((Object)Sign.publicFromPoint((byte[])point.getEncoded(false)), (Matcher)IsEqual.equalTo((Object)SampleKeys.PUBLIC_KEY));
    }
}

