/*
 * Decompiled with CFR 0.152.
 */
package com.platon.crypto;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.platon.crypto.Bip39Wallet;
import com.platon.crypto.Credentials;
import com.platon.crypto.ECKeyPair;
import com.platon.crypto.Hash;
import com.platon.crypto.MnemonicUtils;
import com.platon.crypto.SampleKeys;
import com.platon.crypto.WalletFile;
import com.platon.crypto.WalletUtils;
import com.platon.parameters.NetworkParameters;
import com.platon.utils.Numeric;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Pattern;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class WalletUtilsTest {
    private File tempDir;

    @Before
    public void setUp() throws Exception {
        this.tempDir = WalletUtilsTest.createTempDir();
        NetworkParameters.init((long)2021L, (String)"lxy");
    }

    @Test
    public void testGenerateBip39Wallets() throws Exception {
        Bip39Wallet wallet = WalletUtils.generateBip39Wallet((String)"123456", (File)this.tempDir);
        byte[] seed = MnemonicUtils.generateSeed((String)wallet.getMnemonic(), (String)"123456");
        Credentials credentials = Credentials.create((ECKeyPair)ECKeyPair.create((byte[])Hash.sha256((byte[])seed)));
        Assert.assertEquals((Object)credentials, (Object)WalletUtils.loadBip39Credentials((String)"123456", (String)wallet.getMnemonic()));
    }

    @Test
    public void testGenerateFullNewWalletFile() throws Exception {
        String fileName = WalletUtils.generateFullNewWalletFile((String)"123456", (File)this.tempDir);
        System.out.println("fileName:" + this.tempDir.getAbsolutePath() + "\\" + fileName);
        this.testGeneratedNewWalletFile(fileName);
    }

    @Test
    public void testGenerateNewWalletFile() throws Exception {
        String fileName = WalletUtils.generateNewWalletFile((String)"123456", (File)this.tempDir);
        System.out.println("fileName:" + this.tempDir.getAbsolutePath() + "\\" + fileName);
        this.testGeneratedNewWalletFile(fileName);
    }

    @Test
    public void testGenerateLightNewWalletFile() throws Exception {
        String fileName = WalletUtils.generateLightNewWalletFile((String)"123456", (File)this.tempDir);
        System.out.println("fileName:" + this.tempDir.getAbsolutePath() + "\\" + fileName);
        this.testGeneratedNewWalletFile(fileName);
    }

    @Test
    public void testGeneratePlatONWalletFileByKeyPair() throws Exception {
        String fileName = WalletUtils.generatePlatONWalletFile((String)"123456", (ECKeyPair)SampleKeys.KEY_PAIR, (File)this.tempDir);
        System.out.println("fileName:" + this.tempDir.getAbsolutePath() + "\\" + fileName);
        this.testGeneratedNewWalletFile(fileName);
    }

    @Test
    public void testGeneratePlatONWalletFile() throws Exception {
        String fileName = WalletUtils.generatePlatONWalletFile((String)"123456", (File)this.tempDir);
        System.out.println("fileName:" + this.tempDir.getAbsolutePath() + "\\" + fileName);
        this.testGeneratedNewWalletFile(fileName);
    }

    @Test
    public void testGeneratePlatONBip39Wallet() throws Exception {
        Bip39Wallet wallet = WalletUtils.generatePlatONBip39Wallet((String)"123456", (File)this.tempDir);
        System.out.println("fileName:" + this.tempDir.getAbsolutePath());
        byte[] seed = MnemonicUtils.generateSeed((String)wallet.getMnemonic(), (String)"123456");
        Credentials credentials = Credentials.create((ECKeyPair)ECKeyPair.create((byte[])Hash.sha256((byte[])seed)));
        Assert.assertEquals((Object)credentials, (Object)WalletUtils.loadBip39Credentials((String)"123456", (String)wallet.getMnemonic()));
    }

    private void testGeneratedNewWalletFile(String fileName) throws Exception {
        Credentials c = WalletUtils.loadCredentials((String)"123456", (File)new File(this.tempDir, fileName));
        System.out.println("wallet address: " + c.getAddress());
    }

    @Test
    public void testGenerateFullWalletFile() throws Exception {
        String fileName = WalletUtils.generateWalletFile((String)"123456", (ECKeyPair)SampleKeys.KEY_PAIR, (File)this.tempDir, (boolean)true);
        System.out.println("fileName:" + this.tempDir.getAbsolutePath() + "\\" + fileName);
        this.testGenerateWalletFile(fileName);
    }

    @Test
    public void testGenerateLightWalletFile() throws Exception {
        String fileName = WalletUtils.generateWalletFile((String)"123456", (ECKeyPair)SampleKeys.KEY_PAIR, (File)this.tempDir, (boolean)false);
        System.out.println("fileName:" + this.tempDir.getAbsolutePath() + "\\" + fileName);
        this.testGenerateWalletFile(fileName);
    }

    private void testGenerateWalletFile(String fileName) throws Exception {
        Credentials credentials = WalletUtils.loadCredentials((String)"123456", (File)new File(this.tempDir, fileName));
        Assert.assertThat((Object)credentials, (Matcher)IsEqual.equalTo((Object)SampleKeys.CREDENTIALS));
    }

    @Test
    public void testLoadCredentialsFromFile() throws Exception {
        Credentials credentials = WalletUtils.loadCredentials((String)"123456", (File)new File(WalletUtilsTest.class.getResource("/keyfiles/UTC--2016-11-03T05-55-06.340672473Z--ef678007d18427e6022059dbc264f27507cd1ffc").getFile()));
        Assert.assertThat((Object)credentials, (Matcher)IsEqual.equalTo((Object)SampleKeys.CREDENTIALS));
    }

    @Test
    public void testLoadCredentialsFromOldFormatFile() throws Exception {
        Credentials credentials = WalletUtils.loadCredentials((String)"123456", (File)new File(WalletUtilsTest.class.getResource("/keyfiles/old-format-wallet--ef678007d18427e6022059dbc264f27507cd1ffc.json").getFile()));
        Assert.assertThat((Object)credentials, (Matcher)IsEqual.equalTo((Object)SampleKeys.CREDENTIALS));
    }

    @Test
    public void testLoadCredentialsFromString() throws Exception {
        Credentials credentials = WalletUtils.loadCredentials((String)"123456", (String)WalletUtilsTest.class.getResource("/keyfiles/UTC--2016-11-03T05-55-06.340672473Z--ef678007d18427e6022059dbc264f27507cd1ffc").getFile());
        Assert.assertThat((Object)credentials, (Matcher)IsEqual.equalTo((Object)SampleKeys.CREDENTIALS));
    }

    @Test
    public void testLoadCredentialsFromOldFormatString() throws Exception {
        Credentials credentials = WalletUtils.loadCredentials((String)"123456", (String)WalletUtilsTest.class.getResource("/keyfiles/old-format-wallet--ef678007d18427e6022059dbc264f27507cd1ffc.json").getFile());
        Assert.assertThat((Object)credentials, (Matcher)IsEqual.equalTo((Object)SampleKeys.CREDENTIALS));
    }

    @Ignore
    @Test
    public void testLoadCredentialsMyEtherWallet() throws Exception {
        Credentials credentials = WalletUtils.loadCredentials((String)"123456", (File)new File(WalletUtilsTest.class.getResource("/keyfiles/UTC--2016-11-03T07-47-45.988Z--4f9c1a1efaa7d81ba1cabf07f2c3a5ac5cf4f818").getFile()));
        Assert.assertThat((Object)credentials, (Matcher)IsEqual.equalTo((Object)Credentials.create((String)"6ca4203d715e693279d6cd9742ad2fb7a3f6f4abe27a64da92e0a70ae5d859c9")));
    }

    @Test
    public void testGetDefaultKeyDirectory() {
        Assert.assertTrue((boolean)WalletUtils.getDefaultKeyDirectory((String)"Mac OS X").endsWith(String.format("%sLibrary%sEthereum", File.separator, File.separator)));
        Assert.assertTrue((boolean)WalletUtils.getDefaultKeyDirectory((String)"Windows").endsWith(String.format("%sEthereum", File.separator)));
        Assert.assertTrue((boolean)WalletUtils.getDefaultKeyDirectory((String)"Linux").endsWith(String.format("%s.ethereum", File.separator)));
    }

    @Test
    public void testGetTestnetKeyDirectory() {
        Assert.assertTrue((boolean)WalletUtils.getMainnetKeyDirectory().endsWith(String.format("%skeystore", File.separator)));
        Assert.assertTrue((boolean)WalletUtils.getTestnetKeyDirectory().endsWith(String.format("%stestnet%skeystore", File.separator, File.separator)));
        Assert.assertTrue((boolean)WalletUtils.getRinkebyKeyDirectory().endsWith(String.format("%srinkeby%skeystore", File.separator, File.separator)));
    }

    static File createTempDir() throws Exception {
        return Files.createTempDirectory(WalletUtilsTest.class.getSimpleName() + "-testkeys", new FileAttribute[0]).toFile();
    }

    @Test
    public void testIsValidPrivateKey() {
        Assert.assertTrue((boolean)WalletUtils.isValidPrivateKey((String)"a392604efc2fad9c0b3da43b5f698a2e3f270f170d859912be0d54742275c5f6"));
        Assert.assertTrue((boolean)WalletUtils.isValidPrivateKey((String)Numeric.prependHexPrefix((String)"a392604efc2fad9c0b3da43b5f698a2e3f270f170d859912be0d54742275c5f6")));
        Assert.assertFalse((boolean)WalletUtils.isValidPrivateKey((String)""));
        Assert.assertFalse((boolean)WalletUtils.isValidPrivateKey((String)"a392604efc2fad9c0b3da43b5f698a2e3f270f170d859912be0d54742275c5f6a"));
        Assert.assertFalse((boolean)WalletUtils.isValidPrivateKey((String)"a392604efc2fad9c0b3da43b5f698a2e3f270f170d859912be0d54742275c5f6".substring(1)));
    }

    @Test
    public void testIsValidAddress() {
        Assert.assertTrue((boolean)WalletUtils.isValidAddress((String)SampleKeys.BECH32_ADDRESS));
        Assert.assertFalse((boolean)WalletUtils.isValidAddress((String)""));
        Assert.assertFalse((boolean)WalletUtils.isValidAddress((String)(SampleKeys.BECH32_ADDRESS + 'a')));
        Assert.assertFalse((boolean)WalletUtils.isValidAddress((String)SampleKeys.BECH32_ADDRESS.substring(1)));
    }

    @Test
    public void testLoadCredentialsCurrentFormat() throws Exception {
        Credentials e = WalletUtils.loadCredentials((String)"123456", (File)new File("D:\\swap\\eth.json"));
        System.out.println("eth wallet address: " + e.getAddress());
        Credentials c = WalletUtils.loadCredentials((String)"123456", (File)new File("D:\\swap\\current.json"));
        System.out.println("current wallet address: " + c.getAddress());
        Credentials n = WalletUtils.loadCredentials((String)"123456", (File)new File("D:\\swap\\new.json"));
        System.out.println("new version wallet address: " + n.getAddress());
    }

    @Test
    public void testExp() throws IOException {
        String regex = "\\\"address\\\"\\s*:\\s*\\{\\s*\\\"mainnet\\\"\\s*:\\s*\\\"(\\S*)\\\"[^}]*\\}";
        Pattern main_test_ADDRESS_PATTERN = Pattern.compile(regex);
        String fileContent = "{\n\t\"version\": 3,\n\t\"id\": \"a1741eec-3252-4e0e-b0cf-d506631be3e3\",\n\t\"crypto\": {\n\t\t\"ciphertext\": \"c73370daf300641796e4d5faff7f16a0aeaf1cad97ef1a4b3ac2eaa3e92fc0de\",\n\t\t\"cipherparams\": {\n\t\t\t\"iv\": \"6b7c2ea412fe341a768b105a84c54aba\"\n\t\t},\n\t\t\"kdf\": \"scrypt\",\n\t\t\"kdfparams\": {\n\t\t\t\"r\": 8,\n\t\t\t\"p\": 1,\n\t\t\t\"n\": 16384,\n\t\t\t\"dklen\": 32,\n\t\t\t\"salt\": \"c5b8ffbca4a3f107f55fbbe277ad7a24cb978514d6b45f257f026e78f5f560d9\"\n\t\t},\n\t\t\"mac\": \"091a8f80f552e7284110c9b6b3dba324d49a434890bad427dcb2bcc96a964216\",\n\t\t\"cipher\": \"aes-128-ctr\"\n\t},\n\t\"address\": {\n\t\t\"mainnet\": \"atp1ttx0um8capdsrkfy45yka9f8d39sfqqrklwg98\",\n\t\t\"testnet\": \"atx1ttx0um8capdsrkfy45yka9f8d39sfqqruejzkd\"\n\t}\n}";
        ObjectMapper objectMapper = new ObjectMapper();
        java.util.regex.Matcher matcher = main_test_ADDRESS_PATTERN.matcher(fileContent);
        if (matcher.find()) {
            fileContent = fileContent.replaceAll(regex, "\"address\": \"$1\"");
        }
        System.out.println(fileContent);
        WalletFile walletFile = (WalletFile)objectMapper.readValue(fileContent, WalletFile.class);
        System.out.println(walletFile);
    }

    @Test
    public void testLoadWalletFile() throws IOException {
        File file = new File("src/test/resources/eth.json");
        WalletFile walletFile = WalletUtils.loadWalletFile((File)file);
        System.out.println(walletFile.getAddress() + " : " + walletFile.getCrypto().getCiphertext());
        file = new File("src/test/resources/main_test.json");
        walletFile = WalletUtils.loadWalletFile((File)file);
        System.out.println(walletFile.getAddress() + " : " + walletFile.getCrypto().getCiphertext());
        file = new File("src/test/resources/new.json");
        walletFile = WalletUtils.loadWalletFile((File)file);
        System.out.println(walletFile.getAddress() + " : " + walletFile.getCrypto().getCiphertext());
    }
}

