/*
 * Decompiled with CFR 0.152.
 */
package com.platon.utils;

import com.platon.utils.Strings;
import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class StringsTest {
    @Test
    public void testToCsv() {
        Assert.assertThat((Object)Strings.toCsv(Collections.emptyList()), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)Strings.toCsv(Collections.singletonList("a")), (Matcher)CoreMatchers.is((Object)"a"));
        Assert.assertThat((Object)Strings.toCsv(Arrays.asList("a", "b", "c")), (Matcher)CoreMatchers.is((Object)"a, b, c"));
    }

    @Test
    public void testJoin() {
        Assert.assertThat((Object)Strings.join(Arrays.asList("a", "b"), (String)"|"), (Matcher)CoreMatchers.is((Object)"a|b"));
        Assert.assertNull((Object)Strings.join(null, (String)"|"));
        Assert.assertThat((Object)Strings.join(Collections.singletonList("a"), (String)"|"), (Matcher)CoreMatchers.is((Object)"a"));
    }

    @Test
    public void testCapitaliseFirstLetter() {
        Assert.assertThat((Object)Strings.capitaliseFirstLetter((String)""), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)Strings.capitaliseFirstLetter((String)"a"), (Matcher)CoreMatchers.is((Object)"A"));
        Assert.assertThat((Object)Strings.capitaliseFirstLetter((String)"aa"), (Matcher)CoreMatchers.is((Object)"Aa"));
        Assert.assertThat((Object)Strings.capitaliseFirstLetter((String)"A"), (Matcher)CoreMatchers.is((Object)"A"));
        Assert.assertThat((Object)Strings.capitaliseFirstLetter((String)"Ab"), (Matcher)CoreMatchers.is((Object)"Ab"));
    }

    @Test
    public void testLowercaseFirstLetter() {
        Assert.assertThat((Object)Strings.lowercaseFirstLetter((String)""), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)Strings.lowercaseFirstLetter((String)"A"), (Matcher)CoreMatchers.is((Object)"a"));
        Assert.assertThat((Object)Strings.lowercaseFirstLetter((String)"AA"), (Matcher)CoreMatchers.is((Object)"aA"));
        Assert.assertThat((Object)Strings.lowercaseFirstLetter((String)"a"), (Matcher)CoreMatchers.is((Object)"a"));
        Assert.assertThat((Object)Strings.lowercaseFirstLetter((String)"aB"), (Matcher)CoreMatchers.is((Object)"aB"));
    }

    @Test
    public void testRepeat() {
        Assert.assertThat((Object)Strings.repeat((char)'0', (int)0), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)Strings.repeat((char)'1', (int)3), (Matcher)CoreMatchers.is((Object)"111"));
    }

    @Test
    public void testZeros() {
        Assert.assertThat((Object)Strings.zeros((int)0), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)Strings.zeros((int)3), (Matcher)CoreMatchers.is((Object)"000"));
    }

    @Test
    public void testEmptyString() {
        Assert.assertTrue((boolean)Strings.isEmpty(null));
        Assert.assertTrue((boolean)Strings.isEmpty((String)""));
        Assert.assertFalse((boolean)Strings.isEmpty((String)"hello world"));
    }
}

