/*
 * Decompiled with CFR 0.152.
 */
package com.platon.parameters;

import com.platon.bech32.Bech32;
import com.platon.parameters.InnerContracts;
import java.util.HashMap;
import java.util.Map;

public class NetworkParameters {
    protected long chainId;
    protected String hrp;
    protected static NetworkParameters currentNetwork;
    private static Map<String, NetworkParameters> networksContainer;
    private static String alayaNetworkKey;
    private static String platonNetworkKey;
    protected String pposContractAddressOfRestrictingPlan;
    protected String pposContractAddressOfStaking;
    protected String pposContractAddressOfIncentivePool;
    protected String pposContractAddressOfSlash;
    protected String pposContractAddressOfProposal;
    protected String pposContractAddressOfReward;

    public static long getChainId() {
        return NetworkParameters.currentNetwork.chainId;
    }

    public static String getHrp() {
        return NetworkParameters.currentNetwork.hrp;
    }

    public static String getPposContractAddressOfRestrctingPlan() {
        return NetworkParameters.currentNetwork.pposContractAddressOfRestrictingPlan;
    }

    public static String getPposContractAddressOfStaking() {
        return NetworkParameters.currentNetwork.pposContractAddressOfStaking;
    }

    public static String getPposContractAddressOfIncentivePool() {
        return NetworkParameters.currentNetwork.pposContractAddressOfIncentivePool;
    }

    public static String getPposContractAddressOfSlash() {
        return NetworkParameters.currentNetwork.pposContractAddressOfSlash;
    }

    public static String getPposContractAddressOfProposal() {
        return NetworkParameters.currentNetwork.pposContractAddressOfProposal;
    }

    public static String getPposContractAddressOfReward() {
        return NetworkParameters.currentNetwork.pposContractAddressOfReward;
    }

    protected NetworkParameters() {
    }

    protected NetworkParameters(Long chainID, String hrp) {
        this.chainId = chainID;
        this.hrp = hrp;
        this.pposContractAddressOfRestrictingPlan = Bech32.addressEncode(hrp, InnerContracts.getRestrictingAddr());
        this.pposContractAddressOfStaking = Bech32.addressEncode(hrp, InnerContracts.getStakingAddr());
        this.pposContractAddressOfIncentivePool = Bech32.addressEncode(hrp, InnerContracts.getRewardManagerPoolAddr());
        this.pposContractAddressOfSlash = Bech32.addressEncode(hrp, InnerContracts.getSlashingAddr());
        this.pposContractAddressOfProposal = Bech32.addressEncode(hrp, InnerContracts.getGovAddr());
        this.pposContractAddressOfReward = Bech32.addressEncode(hrp, InnerContracts.getDelegateRewardPoolAddr());
    }

    public static void init(long chainId, String hrp) {
        if (networksContainer.containsKey(String.valueOf(chainId) + ":" + hrp)) {
            return;
        }
        if (chainId == ReservedChainId.Alaya.getChainId() && !ReservedHrp.Alaya.getHrp().equals(hrp)) {
            throw new RuntimeException("hrp not match to chainID");
        }
        if (chainId == ReservedChainId.PlatON.getChainId() && !ReservedHrp.PlatON.getHrp().equals(hrp)) {
            throw new RuntimeException("hrp not match to chainID");
        }
        if (!Bech32.verifyHrp(hrp)) {
            throw new RuntimeException("hrp is invalid");
        }
        NetworkParameters network = new NetworkParameters(chainId, hrp);
        networksContainer.put(String.valueOf(chainId) + ":" + hrp, network);
        currentNetwork = network;
    }

    public static void selectNetwork(long chainId, String hrp) {
        if (networksContainer.keySet().size() == 1) {
            return;
        }
        currentNetwork = networksContainer.get(String.valueOf(chainId) + ":" + hrp);
    }

    public static void selectAlaya() {
        currentNetwork = networksContainer.get(alayaNetworkKey);
    }

    public static void selectPlatON() {
        currentNetwork = networksContainer.get(platonNetworkKey);
    }

    static {
        networksContainer = new HashMap<String, NetworkParameters>();
        alayaNetworkKey = String.valueOf(ReservedChainId.Alaya.getChainId()) + ":" + ReservedHrp.Alaya.getHrp();
        platonNetworkKey = String.valueOf(ReservedChainId.PlatON.getChainId()) + ":" + ReservedHrp.PlatON.getHrp();
        NetworkParameters alaya = new NetworkParameters(ReservedChainId.Alaya.getChainId(), ReservedHrp.Alaya.getHrp());
        networksContainer.put(alayaNetworkKey, alaya);
        currentNetwork = alaya;
    }

    public static enum ReservedChainId {
        PlatON(100L),
        Alaya(201018L);

        private final long chainId;

        private ReservedChainId(long chainId) {
            this.chainId = chainId;
        }

        public long getChainId() {
            return this.chainId;
        }
    }

    public static enum ReservedHrp {
        PlatON("lat"),
        Alaya("atp");

        private final String hrp;

        private ReservedHrp(String hrp) {
            this.hrp = hrp;
        }

        public String getHrp() {
            return this.hrp;
        }
    }
}

