/*
 * Decompiled with CFR 0.152.
 */
package com.platon.bech32;

import com.platon.bech32.Bech32;
import com.platon.parameters.NetworkParameters;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class Bech32Test {
    @Test
    public void addressEncodetOnTestNet() {
        NetworkParameters.init((long)20000L, (String)"atx");
        String hex = "0x4f9c1a1efaa7d81ba1cabf07f2c3a5ac5cf4f818";
        String bech32Address = Bech32.addressEncode((String)NetworkParameters.getHrp(), (String)hex);
        Assert.assertThat((Object)bech32Address, (Matcher)CoreMatchers.is((Object)"atx1f7wp58h65lvphgw2hurl9sa943w0f7qcdcev89"));
    }

    @Test
    public void addressEncodetOnMainNet() {
        String hex = "0x4f9c1a1efaa7d81ba1cabf07f2c3a5ac5cf4f818";
        String bech32Address = Bech32.addressEncode((String)NetworkParameters.getHrp(), (String)hex);
        Assert.assertThat((Object)bech32Address, (Matcher)CoreMatchers.is((Object)"atp1f7wp58h65lvphgw2hurl9sa943w0f7qc879x50"));
    }

    @Test
    public void addressDecodeHexOnTestNet() {
        NetworkParameters.init((long)20000L, (String)"atx");
        String bech32Address = "atx1f7wp58h65lvphgw2hurl9sa943w0f7qcdcev89";
        String hex = Bech32.addressDecodeHex((String)bech32Address);
        Assert.assertThat((Object)hex, (Matcher)CoreMatchers.is((Object)"0x4f9c1a1efaa7d81ba1cabf07f2c3a5ac5cf4f818"));
    }

    @Test
    public void addressDecodeHexOnMainNet() {
        String bech32Address = "atp1f7wp58h65lvphgw2hurl9sa943w0f7qc879x50";
        String hex = Bech32.addressDecodeHex((String)bech32Address);
        Assert.assertThat((Object)hex, (Matcher)CoreMatchers.is((Object)"0x4f9c1a1efaa7d81ba1cabf07f2c3a5ac5cf4f818"));
    }

    @Test
    public void add() {
        NetworkParameters.init((long)201030L, (String)"atx");
        String hex = "0x1000000000000000000000000000000000000005";
        String bech32Address = Bech32.addressEncode((String)NetworkParameters.getHrp(), (String)hex);
        System.out.println("bech32Address:" + bech32Address);
        Assert.assertThat((Object)bech32Address, (Matcher)CoreMatchers.is((Object)"atx1zqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq9zmm967"));
    }

    @Test
    public void testChangeHrp() {
        NetworkParameters.init((long)201018L, (String)"atp");
        String hex = "0x1000000000000000000000000000000000000002";
        String bech32Address = Bech32.addressEncode((String)NetworkParameters.getHrp(), (String)hex);
        System.out.println("bech32Address:" + bech32Address);
        String newAddr = Bech32.changeHrp((String)bech32Address, (String)"lxy");
        System.out.println("newAddr:" + newAddr);
    }

    @Test
    public void testConvertHrp() {
        NetworkParameters.init((long)201018L, (String)"atp");
        System.out.println("newAddr:" + Bech32.changeHrp((String)"atp1l3mv260zc0et6d65qks2hvevmv7t0577qgvhka", (String)"lat"));
    }
}

