/*
 * Decompiled with CFR 0.152.
 */
package com.platon.abi.wasm;

import com.platon.abi.wasm.WasmEventEncoder;
import com.platon.abi.wasm.datatypes.WasmEvent;
import com.platon.abi.wasm.datatypes.WasmEventParameter;
import com.platon.rlp.wasm.ParameterizedTypeImpl;
import com.platon.rlp.wasm.datatypes.Int128;
import com.platon.rlp.wasm.datatypes.Int8;
import com.platon.rlp.wasm.datatypes.Uint128;
import com.platon.rlp.wasm.datatypes.Uint8;
import com.platon.rlp.wasm.datatypes.WasmAddress;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class WasmEventEncoderTest {
    @Test
    public void encodeNumber() {
        BigInteger number = BigInteger.valueOf(246567L);
        String result = WasmEventEncoder.encodeIndexParameter((Object)Uint128.of((BigInteger)number));
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)"0x000000000000000000000000000000000000000000000000000000000003c327"));
        number = BigInteger.valueOf(-246567L);
        result = WasmEventEncoder.encodeIndexParameter((Object)Int128.of((BigInteger)number));
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)"0x000000000000000000000000000000000000000000000000000000000007864d"));
    }

    @Test
    public void encodeBoolean() {
        Boolean bool = true;
        String result = WasmEventEncoder.encodeIndexParameter((Object)bool);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)"0x0000000000000000000000000000000000000000000000000000000000000001"));
        bool = false;
        result = WasmEventEncoder.encodeIndexParameter((Object)bool);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)"0x0000000000000000000000000000000000000000000000000000000000000000"));
    }

    @Test
    public void encodeString() {
        String string = "\u4f60\u597dabc";
        String result = WasmEventEncoder.encodeIndexParameter((Object)string);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)"0x0000000000000000000000000000000000000000000000e4bda0e5a5bd616263"));
        string = "\u4f60\u597dabc\u4f60\u597dabc\u4f60\u597dabc\u4f60\u597dabc\u4f60\u597dabc\u4f60\u597dabc\u4f60\u597dabc\u4f60\u597dabc\u4f60\u597dabc\u4f60\u597dabc\u4f60\u597dabc\u4f60\u597dabc\u4f60\u597dabc\u4f60\u597dabc\u4f60\u597dabc\u4f60\u597dabc\u4f60\u597dabc";
        result = WasmEventEncoder.encodeIndexParameter((Object)string);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)"0xa294cd0e9eff651914801137f53e951abab16791a6a27a7314ac202e35f9e221"));
    }

    @Test
    public void encodeAddress() {
        WasmAddress address = new WasmAddress("lat1f7wp58h65lvphgw2hurl9sa943w0f7qc7gn7tq");
        String result = WasmEventEncoder.encodeIndexParameter((Object)address);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)"0x0000000000000000000000004f9c1a1efaa7d81ba1cabf07f2c3a5ac5cf4f818"));
    }

    @Test
    public void encodeIntUint8List() {
        List<Uint8> uintList = Arrays.asList(Uint8.of((long)240L), Uint8.of((long)12L));
        String result = WasmEventEncoder.encodeIndexParameter(uintList);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)"0x000000000000000000000000000000000000000000000000000000000000f00c"));
        List<Int8> intList = Arrays.asList(Int8.of((long)120L), Int8.of((long)-12L));
        result = WasmEventEncoder.encodeIndexParameter(intList);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)"0x00000000000000000000000000000000000000000000000000000000000078f4"));
    }

    @Test
    public void encodeWasmEvent() {
        WasmEvent event = new WasmEvent("nameAndAddr", Arrays.asList(new WasmEventParameter[0]), Arrays.asList(new WasmEventParameter(Int8[].class), new WasmEventParameter(List.class, (ParameterizedType)new ParameterizedTypeImpl(new Type[]{Int8.class}, List.class, List.class)), new WasmEventParameter(Int8[].class)));
        String result = WasmEventEncoder.encode((WasmEvent)event);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)"0x0000000000000000000000000000000000000000006e616d65416e6441646472"));
    }

    private void char2hex() {
        char[] bytes = new char[]{'\u00e4', '\u00bd', '\u00a0', '\u00e5', '\u00a5', '\u00bd', 'a', 'b', 'c', '\u00e4', '\u00bd', '\u00a0', '\u00e5', '\u00a5', '\u00bd', 'a', 'b', 'c', '\u00e4', '\u00bd', '\u00a0', '\u00e5', '\u00a5', '\u00bd', 'a', 'b', 'c', '\u00e4', '\u00bd', '\u00a0', '\u00e5', '\u00a5'};
        System.out.println();
        for (int i = 0; i < bytes.length; ++i) {
            System.out.print(BigInteger.valueOf(bytes[i]).toString(16));
        }
        System.out.println();
    }
}

