/*
 * Decompiled with CFR 0.152.
 */
package com.platon.rlp.wasm;

import com.platon.rlp.wasm.LazyByteArray;
import com.platon.rlp.wasm.RLPElement;
import com.platon.rlp.wasm.RLPItem;
import com.platon.rlp.wasm.RLPList;
import com.platon.rlp.wasm.RLPParser;
import java.math.BigInteger;

public class LazyElement
implements RLPElement {
    private RLPElement delegate;
    private RLPParser parser;
    private LazyByteArray encoded;

    LazyElement(RLPParser parser) {
        this.parser = parser;
        this.encoded = parser.getLazyByteArray();
    }

    private void parse() {
        if (this.delegate != null) {
            return;
        }
        this.delegate = this.parser.readLazy();
    }

    @Override
    public boolean isRLPList() {
        if (this.delegate != null) {
            return this.delegate.isRLPList();
        }
        return this.parser.peekIsList();
    }

    @Override
    public boolean isRLPItem() {
        return !this.isRLPList();
    }

    @Override
    public RLPList asRLPList() {
        this.parse();
        return this.delegate.asRLPList();
    }

    @Override
    public RLPItem asRLPItem() {
        this.parse();
        return this.delegate.asRLPItem();
    }

    @Override
    public boolean isNull() {
        this.parse();
        return this.delegate.isNull();
    }

    @Override
    public byte[] getEncoded() {
        if (this.delegate == null || this.isRLPItem()) {
            return this.encoded.get();
        }
        this.parse();
        return this.delegate.getEncoded();
    }

    @Override
    public byte[] asBytes() {
        this.parse();
        return this.delegate.asBytes();
    }

    @Override
    public byte asByte() {
        this.parse();
        return this.delegate.asByte();
    }

    @Override
    public short asShort() {
        this.parse();
        return this.delegate.asShort();
    }

    @Override
    public int asInt() {
        this.parse();
        return this.delegate.asInt();
    }

    @Override
    public long asLong() {
        this.parse();
        return this.delegate.asLong();
    }

    @Override
    public BigInteger asBigInteger() {
        this.parse();
        return this.delegate.asBigInteger();
    }

    @Override
    public String asString() {
        this.parse();
        return this.delegate.asString();
    }

    @Override
    public boolean asBoolean() {
        this.parse();
        return this.delegate.asBoolean();
    }

    @Override
    public <T> T as(Class<T> clazz) {
        this.parse();
        return this.delegate.as(clazz);
    }

    @Override
    public RLPElement get(int index) {
        this.parse();
        return this.delegate.get(index);
    }

    @Override
    public boolean add(RLPElement element) {
        this.parse();
        return this.delegate.add(element);
    }

    @Override
    public RLPElement set(int index, RLPElement element) {
        this.parse();
        return this.delegate.set(index, element);
    }

    @Override
    public int size() {
        this.parse();
        return this.delegate.size();
    }
}

