/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.openapi.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.bitexpress.openapi.client.BaseBuilder;
import io.bitexpress.openapi.client.GatewayClient;
import io.bitexpress.openapi.client.GatewayClientImpl;
import io.bitexpress.openapi.client.RequestFactory;
import io.bitexpress.openapi.client.WriteOnlyMappingJackson2HttpMessageConverter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.util.Arrays;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public class GatewayClientBuilder
extends BaseBuilder {
    private String url;
    private ClientHttpRequestFactory clientHttpRequestFactory;
    private Resource pkcs1PrivateKeyPairResource;
    private Resource pkcs8PrivateKeyResource;

    public GatewayClient build() {
        GatewayClientImpl client = new GatewayClientImpl();
        client.setUrl((String)Validate.notBlank((CharSequence)this.url, (String)"url is blank", (Object[])new Object[0]));
        ObjectMapper objectMapper = this.createObjectMapper();
        client.setObjectMapper(objectMapper);
        client.setRequestFactory(this.createRequestFactory(objectMapper));
        client.setRestTemplate(this.createRestTemplate(objectMapper));
        return client;
    }

    private RequestFactory createRequestFactory(ObjectMapper objectMapper) {
        RequestFactory requestFactory;
        block30: {
            requestFactory = new RequestFactory();
            requestFactory.setObjectMapper(objectMapper);
            requestFactory.setUid(this.uid);
            requestFactory.setIssuerCode(this.issuerCode);
            requestFactory.setIssuer(this.issuer);
            if (this.pkcs1PrivateKeyPairResource != null) {
                try (InputStreamReader reader = new InputStreamReader(this.pkcs1PrivateKeyPairResource.getInputStream());){
                    requestFactory.setPrivateKey((PrivateKey)this.keyReader.readPkcs1KeyPair(reader).getLeft());
                    break block30;
                }
                catch (IOException e) {
                    throw new ContextedRuntimeException((Throwable)e);
                }
            }
            if (this.pkcs8PrivateKeyResource != null) {
                try (InputStreamReader reader = new InputStreamReader(this.pkcs8PrivateKeyResource.getInputStream());){
                    requestFactory.setPrivateKey(this.keyReader.readPkcs8PrivateKey(reader));
                    break block30;
                }
                catch (IOException e) {
                    throw new ContextedRuntimeException((Throwable)e);
                }
            }
            throw new IllegalArgumentException("pkcs1PrivateKeyPairResource and pkcs8PrivateKeyResource are both null.");
        }
        return requestFactory;
    }

    private RestTemplate createRestTemplate(ObjectMapper objectMapper) {
        WriteOnlyMappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter = new WriteOnlyMappingJackson2HttpMessageConverter(objectMapper);
        StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter();
        if (this.clientHttpRequestFactory == null) {
            this.clientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        }
        RestTemplate restTemplate = new RestTemplate(this.clientHttpRequestFactory);
        restTemplate.setMessageConverters(Arrays.asList(new HttpMessageConverter[]{mappingJackson2HttpMessageConverter, stringHttpMessageConverter}));
        return restTemplate;
    }

    @Deprecated
    public void setClientPrivateKeyFilePath(Path path) {
        this.setClientPrivateKeyResource((Resource)new FileSystemResource(path));
    }

    @Deprecated
    public void setClientPrivateKeyResource(Resource resource) {
        this.setPkcs1PrivateKeyPairResource(resource);
    }

    public void setPkcs1PrivateKeyPairFilePath(Path path) {
        this.setPkcs1PrivateKeyPairResource((Resource)new FileSystemResource(path));
    }

    public void setPkcs8PrivateKeyFilePath(Path path) {
        this.setPkcs8PrivateKeyResource((Resource)new FileSystemResource(path));
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setClientHttpRequestFactory(ClientHttpRequestFactory clientHttpRequestFactory) {
        this.clientHttpRequestFactory = clientHttpRequestFactory;
    }

    public void setPkcs1PrivateKeyPairResource(Resource pkcs1PrivateKeyPairResource) {
        this.pkcs1PrivateKeyPairResource = pkcs1PrivateKeyPairResource;
    }

    public void setPkcs8PrivateKeyResource(Resource pkcs8PrivateKeyResource) {
        this.pkcs8PrivateKeyResource = pkcs8PrivateKeyResource;
    }
}

