/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.openapi.client.sign.bc;

import io.bitexpress.openapi.client.sign.AbstractKeyMaker;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.openssl.jcajce.JcaPKCS8Generator;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;

public class KeyMakerBcImpl
extends AbstractKeyMaker {
    public static final KeyMakerBcImpl INSTANCE = new KeyMakerBcImpl();

    private KeyMakerBcImpl() {
    }

    @Override
    public Pair<PrivateKey, PublicKey> makePair() {
        KeyPairGenerator keyGen = null;
        try {
            keyGen = KeyPairGenerator.getInstance("RSA", "BC");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new ContextedRuntimeException((Throwable)e);
        }
        keyGen.initialize(2048);
        KeyPair keypair = keyGen.generateKeyPair();
        PrivateKey privateKey = keypair.getPrivate();
        PublicKey publicKey = keypair.getPublic();
        return Pair.of((Object)privateKey, (Object)publicKey);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String exportKey(Key key) {
        try (StringWriter fos = new StringWriter();){
            try (JcaPEMWriter pem = new JcaPEMWriter((Writer)fos);){
                pem.writeObject((Object)key);
                pem.flush();
            }
            fos.flush();
            String string = fos.toString();
            return string;
        }
        catch (IOException e) {
            throw new ContextedRuntimeException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String exportPkcs8Key(PrivateKey key) {
        try (StringWriter fos = new StringWriter();){
            JcaPKCS8Generator gen1 = new JcaPKCS8Generator(key, null);
            PemObject obj1 = gen1.generate();
            try (JcaPEMWriter pem = new JcaPEMWriter((Writer)fos);){
                pem.writeObject((PemObjectGenerator)obj1);
                pem.flush();
            }
            fos.flush();
            String string = fos.toString();
            return string;
        }
        catch (IOException e) {
            throw new ContextedRuntimeException((Throwable)e);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

