/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.topia.commons.basic.cache;

import com.google.common.cache.CacheStats;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class GuavaCacheExpirer {
    private static final Logger logger = LoggerFactory.getLogger(GuavaCacheExpirer.class);
    private CacheManager cacheManager;

    public GuavaCacheExpirer(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void clean() {
        Collection cacheNames = this.cacheManager.getCacheNames();
        for (String string : cacheNames) {
            Cache cache = this.cacheManager.getCache(string);
            if (cache == null) continue;
            com.google.common.cache.Cache nativeCache = (com.google.common.cache.Cache)cache.getNativeCache();
            nativeCache.cleanUp();
            CacheStats stats = nativeCache.stats();
            logger.trace("cache name:{}, size:{}, {}", new Object[]{string, nativeCache.size(), stats});
        }
    }
}

