/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.topia.commons.basic.codec;

import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ContextedRuntimeException;

public class HexBracketToString {
    private static final Pattern pattern = Pattern.compile("\\[.*?\\]");

    private HexBracketToString() {
    }

    public static String decode(String input) {
        Matcher matcher = pattern.matcher(input);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String data = matcher.group();
            data = StringUtils.substringBetween((String)data, (String)"[", (String)"]");
            data = StringUtils.substringAfter((String)data.toLowerCase(), (String)"0x");
            sb.append(data);
        }
        try {
            return new String(Hex.decodeHex((String)sb.toString()), StandardCharsets.UTF_8);
        }
        catch (DecoderException e) {
            throw new ContextedRuntimeException((Throwable)e);
        }
    }
}

