/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.topia.commons.basic.competition;

import io.bitexpress.topia.commons.basic.competition.LockCallback;
import io.bitexpress.topia.commons.basic.competition.LockTemplate2;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class CuratorLockTemplate
implements LockTemplate2 {
    private Logger logger = LoggerFactory.getLogger(CuratorLockTemplate.class);
    private CuratorFramework curatorFramework;
    private String pathPrefix;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(String lockKey, LockCallback<T> lockCallback) {
        String lockKeyPath = lockKey.startsWith("/") ? this.pathPrefix + lockKey : this.pathPrefix + "/" + lockKey;
        InterProcessMutex lock = new InterProcessMutex(this.curatorFramework, lockKeyPath);
        try {
            boolean tryLock = false;
            try {
                this.logger.trace("try locking:{}", (Object)lockKeyPath);
                tryLock = lock.acquire(0L, TimeUnit.MILLISECONDS);
                this.logger.trace("locked {}:{}", (Object)tryLock, (Object)lockKeyPath);
            }
            catch (Exception e) {
                throw new ContextedRuntimeException((Throwable)e);
            }
            if (tryLock) {
                T t = lockCallback.locked();
                return t;
            }
            T t = null;
            return t;
        }
        finally {
            try {
                if (lock.isOwnedByCurrentThread()) {
                    this.logger.trace("unlocking:{}", (Object)lockKeyPath);
                    lock.release();
                    this.logger.trace("unlocked:{}", (Object)lockKeyPath);
                }
            }
            catch (Exception e) {
                this.logger.error("unlock fail", (Throwable)e);
            }
        }
    }

    @Required
    public void setCuratorFramework(CuratorFramework curatorFramework) {
        this.curatorFramework = curatorFramework;
    }

    @Required
    public void setPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
    }

    public void setLoggerName(String loggerName) {
        this.logger = LoggerFactory.getLogger((String)loggerName);
    }
}

