/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.topia.commons.basic.competition;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.cp.lock.FencedLock;
import io.bitexpress.topia.commons.basic.competition.LockCallback;
import io.bitexpress.topia.commons.basic.competition.LockTemplate2;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class HazelcastLockTemplate2
implements LockTemplate2 {
    private static final Logger logger = LoggerFactory.getLogger(HazelcastLockTemplate2.class);
    private HazelcastInstance hazelcastInstance;
    private int leaseMinutes = 30;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(String lockKey, LockCallback<T> lockCallback) {
        FencedLock lock = this.hazelcastInstance.getCPSubsystem().getLock(lockKey);
        boolean tryLock = false;
        try {
            T locked;
            tryLock = lock.tryLock(0L, TimeUnit.SECONDS);
            if (!tryLock) {
                logger.debug("lock failure: {}", (Object)lockKey);
                T t = null;
                return t;
            }
            logger.trace("lock acquired:{}", (Object)lockKey);
            T t = locked = lockCallback.locked();
            return t;
        }
        finally {
            if (tryLock) {
                lock.unlock();
                logger.trace("lock released:{}", (Object)lockKey);
            }
        }
    }

    @Required
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    @Deprecated
    public void setLeaseMinutes(int leaseMinutes) {
        this.leaseMinutes = leaseMinutes;
    }
}

