/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.topia.commons.basic.competition;

import io.bitexpress.topia.commons.basic.competition.LockCallback;
import io.bitexpress.topia.commons.basic.competition.LockTemplate;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.apache.commons.lang3.tuple.Pair;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmLockTemplate
implements LockTemplate {
    private static final Logger logger = LoggerFactory.getLogger(VmLockTemplate.class);
    public static final Period DEFAULT_COOLING_PERIOD = Period.seconds((int)30);
    private Period coolingPeriod = DEFAULT_COOLING_PERIOD;
    private ConcurrentMap<String, Lock> lockMap = new ConcurrentHashMap<String, Lock>();
    private Map<String, Pair<DateTime, String>> lockInfoMap = new ConcurrentHashMap<String, Pair<DateTime, String>>();

    @Override
    public <T> T execute(String lockKey, String scenario, LockCallback<T> lockCallback) {
        Lock lock = (Lock)this.lockMap.get(lockKey);
        if (lock == null) {
            this.lockMap.putIfAbsent(lockKey, new ReentrantLock());
            lock = (Lock)this.lockMap.get(lockKey);
        }
        Pair<DateTime, String> lockInfo = null;
        try {
            boolean tryLock = lock.tryLock(0L, TimeUnit.SECONDS);
            if (!tryLock) {
                logger.debug("lock failure,skip this turn.");
                T t = null;
                return t;
            }
            lockInfo = this.lockInfoMap.get(lockKey);
            if (lockInfo != null && Objects.equals(lockInfo.getRight(), scenario)) {
                DateTime localTime = new DateTime();
                if (((DateTime)lockInfo.getLeft()).isAfter((ReadableInstant)localTime)) {
                    logger.debug("lock time:{} is later than local time:{}.", lockInfo.getLeft(), (Object)localTime);
                    T t = null;
                    return t;
                }
                Interval interval = new Interval((ReadableInstant)lockInfo.getLeft(), (ReadableInstant)localTime);
                if (interval.toDuration().compareTo((ReadableDuration)this.coolingPeriod.toStandardDuration()) <= 0) {
                    logger.debug("cooling:{}", (Object)interval);
                    T t = null;
                    return t;
                }
            }
            T locked = lockCallback.locked();
            this.lockInfoMap.put(lockKey, (Pair<DateTime, String>)Pair.of((Object)new DateTime(), (Object)scenario));
            T t = locked;
            return t;
        }
        catch (InterruptedException e) {
            throw new ContextedRuntimeException((Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    public void setCoolingPeriod(Period coolingPeriod) {
        this.coolingPeriod = coolingPeriod;
    }

    public Map<String, Pair<DateTime, String>> getLockInfoMap() {
        return this.lockInfoMap;
    }
}

