/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.topia.commons.basic.competition;

import io.bitexpress.topia.commons.basic.competition.LockCallback;
import io.bitexpress.topia.commons.basic.competition.LockTemplate2;
import io.bitexpress.topia.commons.basic.competition.VmLockTemplate;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmLockTemplate2
implements LockTemplate2 {
    private static final Logger logger = LoggerFactory.getLogger(VmLockTemplate.class);
    private ConcurrentMap<String, Lock> lockMap = new ConcurrentHashMap<String, Lock>();

    @Override
    public <T> T execute(String lockKey, LockCallback<T> lockCallback) {
        Lock lock = (Lock)this.lockMap.get(lockKey);
        if (lock == null) {
            this.lockMap.putIfAbsent(lockKey, new ReentrantLock());
            lock = (Lock)this.lockMap.get(lockKey);
        }
        try {
            T locked;
            boolean tryLock = lock.tryLock(0L, TimeUnit.SECONDS);
            if (!tryLock) {
                logger.debug("lock failure,skip this turn.{}", (Object)lockKey);
                T t = null;
                return t;
            }
            logger.trace("lock acquired:{}", (Object)lockKey);
            T t = locked = lockCallback.locked();
            return t;
        }
        catch (InterruptedException e) {
            throw new ContextedRuntimeException((Throwable)e);
        }
        finally {
            lock.unlock();
            logger.trace("lock released:{}", (Object)lockKey);
        }
    }
}

