/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.topia.commons.basic.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import io.bitexpress.topia.commons.basic.config.ConfigReader;
import io.bitexpress.topia.commons.basic.exception.ErrorCodeValidate;
import io.bitexpress.topia.commons.basic.jackson.JacksonObjectBuilder;
import io.bitexpress.topia.commons.rpc.error.ErrorCode;
import java.util.List;
import java.util.Map;
import jodd.bean.BeanUtil;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

public class ConfigReaderImpl<KEY, CONF>
implements ConfigReader<KEY, CONF>,
InitializingBean {
    private ObjectMapper objectMapper;
    private Resource jsonResource;
    private Class<CONF> objectType;
    private List<CONF> configList;
    private Map<KEY, CONF> configMap;
    private String keyProperty;
    private ErrorCode notFoundErrorCode;

    @Override
    public CONF getConfig(KEY key) {
        if (this.notFoundErrorCode != null) {
            return ErrorCodeValidate.notNull(this.configMap.get(key), this.notFoundErrorCode, key);
        }
        return (CONF)Validate.notNull(this.configMap.get(key), (String)"config not found,%s", (Object[])new Object[]{key});
    }

    @Override
    public List<CONF> getConfigList() {
        return this.configList;
    }

    public void afterPropertiesSet() throws Exception {
        JacksonObjectBuilder<CONF> builder = new JacksonObjectBuilder<CONF>();
        builder.setObjectMapper(this.objectMapper);
        builder.setObjectType(this.objectType);
        builder.setResource(this.jsonResource);
        this.configList = builder.createObjectList();
        this.configMap = Maps.uniqueIndex(this.configList, (Function)new Function<CONF, KEY>(){

            public KEY apply(CONF conf) {
                return BeanUtil.pojo.getProperty(conf, ConfigReaderImpl.this.keyProperty);
            }
        });
    }

    @Required
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Required
    public void setJsonResource(Resource jsonResource) {
        this.jsonResource = jsonResource;
    }

    @Required
    public void setKeyProperty(String keyProperty) {
        this.keyProperty = keyProperty;
    }

    @Required
    public void setObjectType(Class<CONF> objectType) {
        this.objectType = objectType;
    }

    public void setNotFoundErrorCode(ErrorCode notFoundErrorCode) {
        this.notFoundErrorCode = notFoundErrorCode;
    }
}

