/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.topia.commons.basic.curator;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.bitexpress.topia.commons.basic.curator.SingletonRepo;
import java.io.IOException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.zookeeper.data.Stat;

public class ZookeeperSingletonRepo<T>
implements SingletonRepo<T> {
    private ObjectMapper objectMapper;
    private CuratorFramework curatorFramework;
    private String path;
    private NodeCache nodeCache;
    private Class<T> clazz;

    public void init() throws Exception {
        this.nodeCache = new NodeCache(this.curatorFramework, this.path);
        this.nodeCache.start();
    }

    public void close() throws IOException {
        this.nodeCache.close();
    }

    @Override
    public void delete() {
        try {
            this.curatorFramework.delete().forPath(this.path);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ContextedRuntimeException((Throwable)e);
        }
    }

    @Override
    public void put(T input) {
        try {
            Stat stat;
            byte[] writeValueAsBytes = null;
            if (input != null) {
                writeValueAsBytes = this.objectMapper.writeValueAsBytes(input);
            }
            if ((stat = (Stat)this.curatorFramework.checkExists().forPath(this.path)) == null) {
                this.curatorFramework.create().forPath(this.path, writeValueAsBytes);
            } else {
                this.curatorFramework.setData().forPath(this.path, writeValueAsBytes);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ContextedRuntimeException((Throwable)e);
        }
    }

    @Override
    public T get() {
        try {
            Stat stat = (Stat)this.curatorFramework.checkExists().forPath(this.path);
            if (stat == null) {
                return null;
            }
            byte[] data = (byte[])this.curatorFramework.getData().forPath(this.path);
            if (ArrayUtils.isEmpty((byte[])data)) {
                return null;
            }
            return (T)this.objectMapper.readValue(data, this.clazz);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ContextedRuntimeException((Throwable)e);
        }
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setCuratorFramework(CuratorFramework curatorFramework) {
        this.curatorFramework = curatorFramework;
    }

    public void setClazz(Class<T> clazz) {
        this.clazz = clazz;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

