/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.topia.commons.basic.dubbo;

import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"consumer"})
public class DubboConsumerLoggerFilter
implements Filter {
    public static final int DEFAULT_MAX_PAY_LOAD_LENGTH = 2000;
    private Logger logger = LoggerFactory.getLogger(DubboConsumerLoggerFilter.class);
    private int maxPayLoadLength = 2000;

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        try {
            Result result = invoker.invoke(invocation);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("invocation:{}, result:{}", (Object)StringUtils.abbreviate((String)String.valueOf(invocation), (int)this.maxPayLoadLength), (Object)StringUtils.abbreviate((String)String.valueOf(result.getValue()), (int)this.maxPayLoadLength));
            }
            return result;
        }
        catch (RuntimeException e) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("exception:{}", (Object)StringUtils.abbreviate((String)e.getMessage(), (int)(this.maxPayLoadLength * 2)));
            }
            throw e;
        }
    }

    public void setLogger(String loggerName) {
        this.logger = LoggerFactory.getLogger((String)loggerName);
    }
}

