/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.topia.commons.basic.exception;

import io.bitexpress.topia.commons.basic.exception.ErrorCodeException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class CustomeValidate {
    private CustomeValidate() {
    }

    public static void notBlank(String object, String errorCode, String message, Object ... values) {
        if (StringUtils.isBlank((CharSequence)object)) {
            CustomeValidate.fail(errorCode, message, values);
        }
    }

    public static void notNull(Object object, String errorCode, String message, Object ... values) {
        if (object == null) {
            CustomeValidate.fail(errorCode, message, values);
        }
    }

    public static void isTrue(boolean condition, String errorCode, String message, Object ... values) {
        if (!condition) {
            CustomeValidate.fail(errorCode, message, values);
        }
    }

    public static <T> T fail(String errorCode, String message, Object ... values) {
        if (StringUtils.isNotBlank((CharSequence)message) && ArrayUtils.isNotEmpty((Object[])values)) {
            message = String.format(message, values);
        }
        throw new ErrorCodeException(errorCode, message);
    }
}

