/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.topia.commons.basic.httpclient;

import io.bitexpress.topia.commons.basic.httpclient.DummySslContext;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;

public class DummySslHttpClientBuilder {
    private String proxyAddress;
    private String proxyUsername;
    private String proxyPassword;

    public CloseableHttpClient build() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, KeyManagementException, UnrecoverableKeyException {
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        SSLContext sslcontext = DummySslContext.INSTANCE;
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, null, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        httpClientBuilder = httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
        if (StringUtils.isNotBlank((CharSequence)this.proxyAddress)) {
            HttpHost httpHost = HttpHost.create((String)this.proxyAddress);
            httpClientBuilder = httpClientBuilder.setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(httpHost));
            if (StringUtils.isNotBlank((CharSequence)this.proxyUsername)) {
                AuthScope authScope = new AuthScope(httpHost.getHostName(), httpHost.getPort());
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.proxyUsername, this.proxyPassword);
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(authScope, (Credentials)credentials);
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
            }
        }
        return httpClientBuilder.build();
    }

    public void setProxyAddress(String proxyAddress) {
        this.proxyAddress = proxyAddress;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }
}

