/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.topia.commons.basic.jackson;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.bitexpress.topia.commons.basic.jackson.JacksonObjectBuilder;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

public class JacksonListObjectFactoryBean<T>
implements FactoryBean<List<T>>,
InitializingBean {
    private Resource jsonResource;
    private ObjectMapper objectMapper;
    private Class<T> objectType;
    private List<T> list;

    public void afterPropertiesSet() throws JsonParseException, JsonMappingException, IOException {
        JacksonObjectBuilder<T> builder = new JacksonObjectBuilder<T>();
        builder.setObjectMapper(this.objectMapper);
        builder.setObjectType(this.objectType);
        builder.setResource(this.jsonResource);
        this.list = builder.createObjectList();
    }

    public List<T> getObject() throws Exception {
        return this.list;
    }

    public Class<?> getObjectType() {
        return List.class;
    }

    public boolean isSingleton() {
        return true;
    }

    @Required
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Required
    public void setJsonResource(Resource jsonResource) {
        this.jsonResource = jsonResource;
    }

    @Required
    public void setObjectType(Class<T> objectType) {
        this.objectType = objectType;
    }
}

