/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.topia.commons.basic.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.bitexpress.topia.commons.basic.jackson.JacksonObjectFactory;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.springframework.core.io.Resource;

public class JacksonObjectBuilder<T> {
    private Resource resource;
    private ObjectMapper objectMapper;
    private Class<T> objectType;

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setObjectType(Class<T> objectType) {
        this.objectType = objectType;
    }

    public T createObject() {
        InputStream inputStream = null;
        try {
            inputStream = this.resource.getInputStream();
            T t = JacksonObjectFactory.createObject(this.objectMapper, this.objectType, inputStream);
            return t;
        }
        catch (Exception e) {
            throw new ContextedRuntimeException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public List<T> createObjectList() {
        InputStream inputStream = null;
        try {
            inputStream = this.resource.getInputStream();
            List<T> list = JacksonObjectFactory.createObjectList(this.objectMapper, this.objectType, inputStream);
            return list;
        }
        catch (Exception e) {
            throw new ContextedRuntimeException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }
}

